/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.text.TabExpander;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxHighlightingColorScheme;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;

public abstract class Token {
    public char[] text = null;
    public int textOffset = -1;
    public int textCount = -1;
    public int offset = -1;
    public int type = 0;
    private Token nextToken = null;
    private Rectangle2D.Float bgRect = new Rectangle2D.Float();
    public static final int NULL = 0;
    public static final int COMMENT = 1;
    public static final int COMMENT_EOL = 2;
    public static final int COMMENT_MULTILINE = 3;
    public static final int COMMENT_DOCUMENTATION = 4;
    public static final int RESERVED_WORD = 5;
    public static final int FUNCTION = 6;
    public static final int LITERAL = 7;
    public static final int LITERAL_BOOLEAN = 8;
    public static final int LITERAL_NUMBER_DECIMAL_INT = 9;
    public static final int LITERAL_NUMBER_FLOAT = 10;
    public static final int LITERAL_NUMBER_HEXADECIMAL = 11;
    public static final int LITERAL_STRING_DOUBLE_QUOTE = 12;
    public static final int LITERAL_CHAR = 13;
    public static final int LITERAL_BACKQUOTE = 14;
    public static final int DATA_TYPE = 15;
    public static final int VARIABLE = 16;
    public static final int IDENTIFIER = 17;
    public static final int WHITESPACE = 18;
    public static final int SEPARATOR = 19;
    public static final int OPERATOR = 20;
    public static final int PREPROCESSOR = 21;
    public static final int ERROR = 22;
    public static final int ERROR_IDENTIFIER = 23;
    public static final int ERROR_NUMBER_FORMAT = 24;
    public static final int ERROR_STRING_DOUBLE = 25;
    public static final int ERROR_CHAR = 26;
    public static final int NUM_TOKEN_TYPES = 27;

    public Token() {
    }

    public Token(char[] cArray, int n, int n2, int n3, int n4) {
        this();
        this.set(cArray, n, n2, n3, n4);
    }

    public Token(Token token) {
        this();
        this.copyFrom(token);
    }

    public boolean containsPosition(int n) {
        return n >= this.offset && n < this.offset + this.textCount;
    }

    public void copyFrom(Token token) {
        this.text = token.text;
        this.textOffset = token.textOffset;
        this.textCount = token.textCount;
        this.offset = token.offset;
        this.type = token.type;
        this.nextToken = token.nextToken;
    }

    public int documentToToken(int n) {
        return n + (this.textOffset - this.offset);
    }

    private static final String getHTMLFormatForColor(Color color) {
        String string;
        String string2;
        if (color == null) {
            return "#000000";
        }
        String string3 = Integer.toHexString(color.getRed());
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen())).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue())).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    public String getHTMLRepresentation(RSyntaxTextArea rSyntaxTextArea) {
        SyntaxHighlightingColorScheme syntaxHighlightingColorScheme = rSyntaxTextArea.getSyntaxHighlightingColorScheme();
        SyntaxScheme syntaxScheme = syntaxHighlightingColorScheme.syntaxSchemes[this.type];
        Font font = rSyntaxTextArea.getFontForTokenType(this.type);
        StringBuffer stringBuffer = new StringBuffer();
        if (font.isBold()) {
            stringBuffer.append("<b>");
        }
        if (font.isItalic()) {
            stringBuffer.append("<em>");
        }
        if (syntaxScheme.underline) {
            stringBuffer.append("<u>");
        }
        stringBuffer.append("<font face=\"").append(font.getFamily()).append("\" color=\"").append(Token.getHTMLFormatForColor(syntaxScheme.foreground)).append("\">");
        String string = this.getLexeme().replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        stringBuffer.append(string);
        stringBuffer.append("</font>");
        if (syntaxScheme.underline) {
            stringBuffer.append("</u>");
        }
        if (font.isItalic()) {
            stringBuffer.append("</em>");
        }
        if (font.isBold()) {
            stringBuffer.append("</b>");
        }
        return stringBuffer.toString();
    }

    public String getLexeme() {
        return new String(this.text, this.textOffset, this.textCount);
    }

    public abstract int getListOffset(RSyntaxTextArea var1, TabExpander var2, float var3, float var4);

    public Token getNextToken() {
        return this.nextToken;
    }

    public int getOffsetBeforeX(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f, float f2) {
        int n;
        FontMetrics fontMetrics = rSyntaxTextArea.getFontMetricsForTokenType(this.type);
        int n2 = n + this.textCount;
        float f3 = f;
        for (n = this.textOffset; n < n2; ++n) {
            f3 = this.text[n] == '\t' ? tabExpander.nextTabStop(f3, 0) : (f3 += (float)fontMetrics.charWidth(this.text[n]));
            if (!(f3 > f2)) continue;
            int n3 = Math.max(n - this.textOffset, 1);
            return this.offset + n3;
        }
        return n2 - 1;
    }

    public float getWidth(RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander, float f) {
        return this.getWidthUpTo(this.textCount, rSyntaxTextArea, tabExpander, f);
    }

    public abstract float getWidthUpTo(int var1, RSyntaxTextArea var2, TabExpander var3, float var4);

    public boolean isPaintable() {
        return this.type > 0;
    }

    public boolean isWhitespace() {
        return this.type == 18;
    }

    public abstract Rectangle listOffsetToView(RSyntaxTextArea var1, TabExpander var2, int var3, int var4, Rectangle var5);

    public abstract void makeStartAt(int var1);

    public final float paint(Graphics2D graphics2D, float f, float f2, RSyntaxTextArea rSyntaxTextArea, TabExpander tabExpander) {
        return this.paint(graphics2D, f, f2, rSyntaxTextArea, tabExpander, 0.0f);
    }

    public abstract float paint(Graphics2D var1, float var2, float var3, RSyntaxTextArea var4, TabExpander var5, float var6);

    protected void paintBackground(float f, float f2, float f3, float f4, Graphics2D graphics2D, int n, RSyntaxTextArea rSyntaxTextArea, Color color) {
        Color color2 = rSyntaxTextArea.getBackground();
        graphics2D.setXORMode(color2 != null ? color2 : Color.WHITE);
        graphics2D.setColor(color);
        this.bgRect.setRect(f, f2 - (float)n, f3, f4);
        graphics2D.fill(this.bgRect);
        graphics2D.setPaintMode();
    }

    public void set(char[] cArray, int n, int n2, int n3, int n4) {
        this.text = cArray;
        this.textOffset = n;
        this.textCount = n2 - n + 1;
        this.type = n4;
        this.offset = n3;
        this.nextToken = null;
    }

    public void setNextToken(Token token) {
        this.nextToken = token;
    }

    public int tokenToDocument(int n) {
        return n + (this.offset - this.textOffset);
    }

    public String toString() {
        return "[Token: " + (this.type == 0 ? "<null token>" : "text: '" + (this.text == null ? "<null>" : this.getLexeme() + "'; " + "offset: " + this.offset + "; type: " + this.type + "; " + "isPaintable: " + this.isPaintable() + "; nextToken==null: " + (this.nextToken == null))) + "]";
    }
}

