/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.antlr;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileType;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.antlr.internal.AntlrExecuter;
import org.gradle.api.plugins.antlr.internal.AntlrResult;
import org.gradle.api.plugins.antlr.internal.AntlrSourceGenerationException;
import org.gradle.api.plugins.antlr.internal.AntlrSpec;
import org.gradle.api.plugins.antlr.internal.AntlrSpecFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.worker.MultiRequestClient;
import org.gradle.process.internal.worker.MultiRequestWorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;

@NonNullApi
@CacheableTask
public abstract class AntlrTask
extends SourceTask {
    private boolean trace;
    private boolean traceLexer;
    private boolean traceParser;
    private boolean traceTreeWalker;
    private List<String> arguments = new ArrayList<String>();
    private FileCollection antlrClasspath;
    private File outputDirectory;
    private String maxHeapSize;
    private FileCollection sourceSetDirectories;
    private final FileCollection stableSources = this.getProject().files(new Object[]{this::getSource});

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isTrace() {
        return this.trace;
    }

    public void setTrace(boolean trace) {
        this.trace = trace;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isTraceLexer() {
        return this.traceLexer;
    }

    public void setTraceLexer(boolean traceLexer) {
        this.traceLexer = traceLexer;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isTraceParser() {
        return this.traceParser;
    }

    public void setTraceParser(boolean traceParser) {
        this.traceParser = traceParser;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isTraceTreeWalker() {
        return this.traceTreeWalker;
    }

    public void setTraceTreeWalker(boolean traceTreeWalker) {
        this.traceTreeWalker = traceTreeWalker;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public void setMaxHeapSize(String maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    public void setArguments(List<String> arguments) {
        if (arguments != null) {
            this.arguments = arguments;
        }
    }

    @Input
    @ToBeReplacedByLazyProperty
    public List<String> getArguments() {
        return this.arguments;
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Classpath
    @ToBeReplacedByLazyProperty(unreported=true, comment="Setter has protected access")
    public FileCollection getAntlrClasspath() {
        return this.antlrClasspath;
    }

    protected void setAntlrClasspath(FileCollection antlrClasspath) {
        this.antlrClasspath = antlrClasspath;
    }

    @Inject
    protected WorkerProcessFactory getWorkerProcessBuilderFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public void execute(InputChanges inputChanges) {
        AntlrResult result;
        HashSet<File> grammarFiles = new HashSet<File>();
        FileCollection stableSources = this.getStableSources();
        if (inputChanges.isIncremental()) {
            boolean rebuildRequired = false;
            for (FileChange fileChange : inputChanges.getFileChanges(stableSources)) {
                if (fileChange.getFileType() != FileType.FILE) continue;
                if (fileChange.getChangeType() == ChangeType.REMOVED) {
                    rebuildRequired = true;
                    break;
                }
                grammarFiles.add(fileChange.getFile());
            }
            if (rebuildRequired) {
                try {
                    this.getDeleter().ensureEmptyDirectory(this.outputDirectory);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
                grammarFiles.addAll(stableSources.getFiles());
            }
        } else {
            grammarFiles.addAll(stableSources.getFiles());
        }
        AntlrSpec spec = new AntlrSpecFactory().create(this, grammarFiles, this.sourceSetDirectories);
        MultiRequestClient<AntlrSpec, AntlrResult> client = this.getAntlrWorkerClient(spec);
        try {
            client.start();
            result = (AntlrResult)client.run((Object)spec);
        }
        finally {
            client.stop();
        }
        this.evaluate(result);
    }

    private MultiRequestClient<AntlrSpec, AntlrResult> getAntlrWorkerClient(AntlrSpec spec) {
        MultiRequestWorkerProcessBuilder builder = this.getWorkerProcessBuilderFactory().multiRequestWorker(AntlrExecuter.class);
        builder.setBaseName("Gradle ANTLR Worker");
        builder.applicationClasspath((Iterable)this.getAntlrClasspath());
        builder.sharedPackages(new String[]{"antlr", "org.antlr"});
        JavaExecHandleBuilder javaCommand = builder.getJavaCommand();
        javaCommand.setWorkingDir(this.projectDir());
        javaCommand.setMaxHeapSize(spec.getMaxHeapSize());
        javaCommand.systemProperty("ANTLR_DO_NOT_EXIT", (Object)"true");
        javaCommand.redirectErrorStream();
        return builder.build();
    }

    private void evaluate(AntlrResult result) {
        int errorCount = result.getErrorCount();
        if (errorCount < 0) {
            throw new AntlrSourceGenerationException("There were errors during grammar generation", result.getException());
        }
        if (errorCount == 1) {
            throw new AntlrSourceGenerationException("There was 1 error during grammar generation", result.getException());
        }
        if (errorCount > 1) {
            throw new AntlrSourceGenerationException("There were " + errorCount + " errors during grammar generation", result.getException());
        }
    }

    private File projectDir() {
        return this.getProjectLayout().getProjectDirectory().getAsFile();
    }

    public void setSource(FileTree source) {
        this.setSource((Object)source);
    }

    public void setSource(Object source) {
        super.setSource(source);
        if (source instanceof SourceDirectorySet) {
            this.sourceSetDirectories = ((SourceDirectorySet)source).getSourceDirectories();
        }
    }

    @Internal(value="tracked via stableSources")
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputFiles
    protected FileCollection getStableSources() {
        return this.stableSources;
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }
}

