/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

public final class TestEntry {
    private static final String TEST_DIST_DIR = "nbbuild/build/testdist";
    private final String codeNameBase;
    private final String testType;
    private final String cluster;
    private final File jarFile;

    private TestEntry(File jarFile, String codeNameBase, String testType, String cluster) {
        this.jarFile = jarFile;
        this.codeNameBase = codeNameBase;
        this.testType = testType;
        this.cluster = cluster;
    }

    public static TestEntry get(File jarFile) {
        String[] tokens;
        int len;
        if (jarFile.getName().equals("tests.jar") && (len = (tokens = jarFile.getPath().split("[/\\\\]")).length) > 3) {
            String cnb = tokens[len - 2].replace('-', '.');
            String cluster = tokens[len - 3];
            String testType = tokens[len - 4];
            return new TestEntry(jarFile, cnb, testType, cluster);
        }
        return null;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getCluster() {
        return this.cluster == null ? "cluster" : this.cluster;
    }

    public File getJarFile() {
        return this.jarFile;
    }

    public File getTestDistRoot() {
        File ret = this.getJarFile();
        for (int i = 0; i < 4 && ret != null; ret = ret.getParentFile(), ++i) {
        }
        return ret;
    }

    public URL getSrcDir() throws IOException {
        SubprojectProvider subprojects;
        String nborgPath = this.getNetBeansOrgPath();
        if (nborgPath != null) {
            return Utilities.toURI((File)new File(this.getNBRoot(), nborgPath)).toURL();
        }
        File prjDir = this.getTestDistRoot();
        if (prjDir == null) {
            return null;
        }
        while (!prjDir.exists()) {
            if ((prjDir = prjDir.getParentFile()) != null) continue;
            return null;
        }
        Project prj = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)prjDir));
        if (prj != null && prj.getLookup().lookup(SuiteProject.class) != null && (subprojects = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project p : subprojects.getSubprojects()) {
                FileObject file;
                NbModuleProject nbm;
                if (!(p instanceof NbModuleProject) || (nbm = (NbModuleProject)p) == null || !nbm.getCodeNameBase().equals(this.getCodeNameBase()) || (file = nbm.getTestSourceDirectory(this.testType)) == null) continue;
                return file.toURL();
            }
        }
        return null;
    }

    File getNBRoot() {
        File rootDir = this.getTestDistRoot();
        if (rootDir == null) {
            return null;
        }
        String path = rootDir.getAbsolutePath().replace(File.separatorChar, '/');
        File nbroot = null;
        if (path.endsWith(TEST_DIST_DIR)) {
            nbroot = rootDir.getParentFile().getParentFile().getParentFile();
        }
        return nbroot;
    }

    public String getNetBeansOrgPath() throws IOException {
        File nbroot = this.getNBRoot();
        if (nbroot != null && ModuleList.isNetBeansOrg(nbroot)) {
            ModuleList list = ModuleList.findOrCreateModuleListFromNetBeansOrgSources(nbroot);
            ModuleEntry entry = list.getEntry(this.codeNameBase);
            if (entry == null) {
                return null;
            }
            return entry.getNetBeansOrgPath() + "/test/" + this.getTestType() + "/src";
        }
        return null;
    }

    public String getTestType() {
        return this.testType;
    }

    public Project getProject() {
        try {
            URI uri;
            URL url = this.getSrcDir();
            if (url != null && (uri = url.toURI()) != null) {
                return FileOwnerQuery.getOwner((URI)uri);
            }
        }
        catch (IOException ex) {
            Util.err.notify((Throwable)ex);
        }
        catch (URISyntaxException ex) {
            Util.err.notify((Throwable)ex);
        }
        return null;
    }

    public String toString() {
        try {
            return "TestEntry[" + this.jarFile + ",src=" + this.getSrcDir() + "]";
        }
        catch (IOException x) {
            return "TestEntry[" + this.jarFile + ",src=<" + x.getMessage() + ">]";
        }
    }
}

