/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.assets;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.bucket.BucketItem;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.developer.MetricsNamespaceItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;

public final class PropertiesGenerator {
    private static final String DEFAULT = "DEFAULT";
    final Map<String, String> application = new HashMap<String, String>();
    final Map<String, String> bootstrap = new HashMap<String, String>();
    final Map<String, String> secrets = new HashMap<String, String>();
    final List<String> allPropertiesNames = Arrays.asList("micronaut.object-storage.oracle-cloud.default.bucket", "micronaut.object-storage.oracle-cloud.default.namespace", "datasources.default.dialect", "datasources.default.ocid", "datasources.default.walletPassword", "datasources.default.username", "datasources.default.password", "datasources.default.url", "oci.config.instance-principal.enabled", "oci.vault.config.enabled", "oci.vault.vaults[0].ocid", "oci.vault.vaults[0].compartment-ocid", "micronaut.metrics.enabled", "micronaut.metrics.binders.files.enabled", "micronaut.metrics.binders.jdbc.enabled", "micronaut.metrics.binders.jvm.enabled", "micronaut.metrics.binders.logback.enabled", "micronaut.metrics.binders.processor.enabled", "micronaut.metrics.binders.uptime.enabled", "micronaut.metrics.binders.web.enabled", "micronaut.metrics.export.oraclecloud.enabled", "micronaut.metrics.export.oraclecloud.namespace", "micronaut.metrics.export.oraclecloud.compartmentId");

    public PropertiesGenerator(boolean local) {
        Collection<OCIItem> items = CloudAssets.getDefault().getItems();
        VaultItem vault = null;
        for (OCIItem item : items) {
            if (!"Vault".equals(item.getKey().getPath())) continue;
            vault = (VaultItem)item;
        }
        block11: for (OCIItem item : items) {
            String refName = CloudAssets.getDefault().getReferenceName(item);
            if (refName == null) {
                refName = DEFAULT;
            }
            String nameLowercase = refName.toLowerCase();
            String refNameUppercase = refName.toUpperCase();
            switch (item.getKey().getPath()) {
                case "Bucket": {
                    this.application.put("micronaut.object-storage.oracle-cloud." + nameLowercase + ".bucket", item.getKey().getValue());
                    this.application.put("micronaut.object-storage.oracle-cloud." + nameLowercase + ".namespace", ((BucketItem)item).getNamespace());
                    break;
                }
                case "Database": {
                    DatabaseConnection conn = ((DatabaseItem)item).getCorrespondingConnection();
                    if (conn == null) break;
                    if (vault != null) {
                        this.application.put("datasources." + nameLowercase + ".dialect", "ORACLE");
                        this.application.put("datasources." + nameLowercase + ".ocid", "${DATASOURCES_" + refNameUppercase + "_OCID}");
                        this.application.put("datasources." + nameLowercase + ".walletPassword", "${DATASOURCES_" + refNameUppercase + "_WALLET_PASSWORD}");
                        this.application.put("datasources." + nameLowercase + ".username", "${DATASOURCES_" + refNameUppercase + "_USERNAME}");
                        this.application.put("datasources." + nameLowercase + ".password", "${DATASOURCES_" + refNameUppercase + "_PASSWORD}");
                        this.putSecret(refNameUppercase, "Username", conn.getUser());
                        this.putSecret(refNameUppercase, "Password", conn.getPassword());
                        this.putSecret(refNameUppercase, "OCID", (String)conn.getConnectionProperties().get("OCID"));
                        this.putSecret(refNameUppercase, "CompartmentOCID", (String)conn.getConnectionProperties().get("CompartmentOCID"));
                        this.putSecret(refNameUppercase, "wallet_Password", UUID.randomUUID().toString());
                        break;
                    }
                    if (local) {
                        this.application.put("datasources." + nameLowercase + ".url", conn.getDatabaseURL());
                    }
                    this.application.put("datasources." + nameLowercase + ".username", conn.getUser());
                    this.application.put("datasources." + nameLowercase + ".password", conn.getPassword());
                    this.application.put("datasources." + nameLowercase + ".walletPassword", UUID.randomUUID().toString());
                    this.application.put("datasources." + nameLowercase + ".driverClassName", conn.getDriverClass());
                    String ocid = (String)conn.getConnectionProperties().get("OCID");
                    if (ocid == null || ocid.isEmpty()) continue block11;
                    this.application.put("datasources." + nameLowercase + ".ocid", ocid);
                    break;
                }
                case "MetricsNamespace": {
                    this.application.put("micronaut.metrics.enabled", "true");
                    this.application.put("micronaut.metrics.binders.files.enabled", "true");
                    this.application.put("micronaut.metrics.binders.jdbc.enabled", "true");
                    this.application.put("micronaut.metrics.binders.jvm.enabled", "true");
                    this.application.put("micronaut.metrics.binders.logback.enabled", "true");
                    this.application.put("micronaut.metrics.binders.processor.enabled", "true");
                    this.application.put("micronaut.metrics.binders.uptime.enabled", "true");
                    this.application.put("micronaut.metrics.binders.web.enabled", "true");
                    this.application.put("micronaut.metrics.export.oraclecloud.enabled", "true");
                    this.application.put("micronaut.metrics.export.oraclecloud.namespace", ((MetricsNamespaceItem)item).getName());
                    this.application.put("micronaut.metrics.export.oraclecloud.compartmentId", ((MetricsNamespaceItem)item).getCompartmentId());
                }
            }
        }
        if (!local) {
            this.bootstrap.put("oci.config.instance-principal.enabled", "true");
        }
        if (vault != null) {
            this.bootstrap.put("oci.vault.config.enabled", "true");
            this.bootstrap.put("micronaut.config-client.enabled", "true");
            this.bootstrap.put("oci.vault.vaults[0].ocid", vault.getKey().getValue());
            this.bootstrap.put("oci.vault.vaults[0].compartment-ocid", vault.getCompartmentId());
        }
    }

    private void putSecret(String datasourceName, String name, String value) {
        String secretName = "DATASOURCES_" + datasourceName + "_" + name;
        this.secrets.put(secretName, value);
    }

    public Collection<String> getAllPropertiesNames() {
        return this.allPropertiesNames;
    }

    public synchronized Map<String, String> getApplication() {
        return Collections.unmodifiableMap(this.application);
    }

    public synchronized Map<String, String> getBootstrap() {
        return Collections.unmodifiableMap(this.bootstrap);
    }

    public synchronized Map<String, String> getVaultSecrets() {
        return Collections.unmodifiableMap(this.secrets);
    }
}

