/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.completion;

import java.util.Map;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.completion.CaretLocation;
import org.netbeans.modules.groovy.editor.api.completion.CompletionItem;
import org.netbeans.modules.groovy.editor.api.completion.util.CompletionContext;
import org.netbeans.modules.groovy.editor.api.elements.KeywordElement;
import org.netbeans.modules.groovy.editor.completion.BaseCompletion;
import org.netbeans.modules.groovy.editor.completion.SpockUtils;
import org.openide.util.ImageUtilities;

public class SpockBlockNamesCompletion
extends BaseCompletion {
    @Override
    public boolean complete(Map<Object, CompletionProposal> proposals, CompletionContext request, int anchor) {
        if (request.location == CaretLocation.INSIDE_METHOD && SpockUtils.isInSpecificationClass(request)) {
            for (SpockBlock block : SpockBlock.values()) {
                if (!block.name.startsWith(request.getPrefix())) continue;
                proposals.put("spockblock:" + block.name, (CompletionProposal)new SpockBlockItem(block.name, anchor));
            }
        }
        return true;
    }

    static enum SpockBlock {
        SPOCK_and("and"),
        SPOCK_cleanup("cleanup"),
        SPOCK_expect("expect"),
        SPOCK_given("given"),
        SPOCK_setup("setup"),
        SPOCK_then("then"),
        SPOCK_when("when"),
        SPOCK_where("where");

        private final String name;

        private SpockBlock(String name) {
            this.name = name;
        }
    }

    static class SpockBlockItem
    extends CompletionItem {
        private static final String ICON_PATH = "org/netbeans/modules/groovy/editor/resources/spock-16x16.png";
        private final String name;
        private static volatile ImageIcon spockIcon;

        public SpockBlockItem(String name, int anchorOffset) {
            super(new KeywordElement(name), anchorOffset);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.KEYWORD;
        }

        public ImageIcon getIcon() {
            if (spockIcon == null) {
                spockIcon = ImageUtilities.loadImageIcon((String)ICON_PATH, (boolean)false);
            }
            return spockIcon;
        }

        public String getInsertPrefix() {
            return this.getName() + ": ";
        }
    }
}

