/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.micronaut.completion;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.swing.text.Document;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lsp.Completion;
import org.netbeans.api.lsp.TextEdit;
import org.netbeans.modules.micronaut.completion.MicronautDataCompletionTask;
import org.netbeans.modules.micronaut.db.Utils;
import org.netbeans.modules.micronaut.expression.MicronautExpressionLanguageUtilities;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.lsp.CompletionCollector;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class MicronautDataCompletionCollector
implements CompletionCollector {
    public boolean collectCompletions(Document doc, int offset, Completion.Context context, Consumer<Completion> consumer) {
        new MicronautDataCompletionTask().query(doc, offset, new MicronautDataCompletionTask.ItemFactory<Completion>(){

            @Override
            public Completion createControllerMethodItem(CompilationInfo info, String annName, String controllerId, int offset) {
                String methodName = Utils.getControllerEndpointMethodName(annName);
                if (methodName != null) {
                    StringBuilder labelDetail = new StringBuilder();
                    StringBuilder sortParams = new StringBuilder();
                    labelDetail.append('(');
                    sortParams.append('(');
                    int cnt = 0;
                    if ("io.micronaut.http.annotation.Put".equals(annName) || "io.micronaut.http.annotation.Post".equals(annName)) {
                        labelDetail.append("String value");
                        sortParams.append("String");
                        ++cnt;
                    }
                    sortParams.append(')');
                    labelDetail.append(')');
                    TypeMirror returnType = Utils.getControllerEndpointReturnType(info, annName);
                    FileObject fo = info.getFileObject();
                    return CompletionCollector.newBuilder((String)methodName).kind(Completion.Kind.Method).labelDetail(String.format("%s - generate", labelDetail.toString())).labelDescription(Utils.getTypeName(info, returnType, false, false).toString()).sortText(String.format("%04d%s#%02d%s", 1500, methodName, cnt, sortParams.toString())).insertTextFormat(Completion.TextFormat.PlainText).textEdit(new TextEdit(offset, offset, "")).additionalTextEdits(() -> MicronautDataCompletionCollector.modify2TextEdits(JavaSource.forFileObject((FileObject)fo), (Task<WorkingCopy>)wc -> {
                        TypeElement te;
                        wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath tp = wc.getTreeUtilities().pathFor(offset);
                        TypeElement typeElement = te = TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? (TypeElement)wc.getTrees().getElement(tp) : null;
                        if (te != null) {
                            ClassTree clazz = (ClassTree)tp.getLeaf();
                            HashSet<Element> toImport = new HashSet<Element>();
                            MethodTree mt = Utils.createControllerEndpointMethod(wc, methodName, controllerId, toImport);
                            wc.rewrite((Tree)clazz, (Tree)GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(clazz, (Tree)mt, offset));
                            wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)wc).addImports(wc.getCompilationUnit(), toImport));
                        }
                    })).build();
                }
                return null;
            }

            @Override
            public Completion createControllerMethodItem(CompilationInfo info, VariableElement delegateRepository, ExecutableElement delegateMethod, String controllerId, String id, int offset) {
                String delegateMethodName = delegateMethod.getSimpleName().toString();
                String methodName = Utils.getControllerDataEndpointMethodName(delegateMethodName, id);
                TypeMirror delegateRepositoryType = delegateRepository.asType();
                if (delegateRepositoryType.getKind() == TypeKind.DECLARED) {
                    TypeMirror tm;
                    ExecutableType type = (ExecutableType)info.getTypes().asMemberOf((DeclaredType)delegateRepositoryType, delegateMethod);
                    Iterator<? extends VariableElement> it = delegateMethod.getParameters().iterator();
                    Iterator<? extends TypeMirror> tIt = type.getParameterTypes().iterator();
                    StringBuilder labelDetail = new StringBuilder();
                    StringBuilder sortParams = new StringBuilder();
                    labelDetail.append('(');
                    sortParams.append('(');
                    int cnt = 0;
                    while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                        ++cnt;
                        String paramTypeName = Utils.getTypeName(info, tm, false, delegateMethod.isVarArgs() && !tIt.hasNext()).toString();
                        String paramName = it.next().getSimpleName().toString();
                        labelDetail.append(paramTypeName).append(' ').append(paramName);
                        sortParams.append(paramTypeName);
                        if (!tIt.hasNext()) continue;
                        labelDetail.append(", ");
                        sortParams.append(',');
                    }
                    sortParams.append(')');
                    labelDetail.append(')');
                    TypeMirror returnType = Utils.getControllerDataEndpointReturnType(info, delegateMethodName, type);
                    FileObject fo = info.getFileObject();
                    ElementHandle repositoryHandle = ElementHandle.create((Element)delegateRepository);
                    ElementHandle methodHandle = ElementHandle.create((Element)delegateMethod);
                    return CompletionCollector.newBuilder((String)methodName).kind(Completion.Kind.Method).labelDetail(String.format("%s - generate", labelDetail.toString())).labelDescription(Utils.getTypeName(info, returnType, false, false).toString()).sortText(String.format("%04d%s#%02d%s", 1500, methodName, cnt, sortParams.toString())).insertTextFormat(Completion.TextFormat.PlainText).textEdit(new TextEdit(offset, offset, "")).additionalTextEdits(() -> MicronautDataCompletionCollector.modify2TextEdits(JavaSource.forFileObject((FileObject)fo), (Task<WorkingCopy>)wc -> {
                        TypeElement te;
                        wc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TreePath tp = wc.getTreeUtilities().pathFor(offset);
                        TypeElement typeElement = te = TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()) ? (TypeElement)wc.getTrees().getElement(tp) : null;
                        if (te != null) {
                            TypeMirror repositoryType;
                            ClassTree clazz = (ClassTree)tp.getLeaf();
                            VariableElement repository = (VariableElement)repositoryHandle.resolve((CompilationInfo)wc);
                            ExecutableElement method = (ExecutableElement)methodHandle.resolve((CompilationInfo)wc);
                            if (repository != null && method != null && (repositoryType = repository.asType()).getKind() == TypeKind.DECLARED) {
                                HashSet<Element> toImport = new HashSet<Element>();
                                MethodTree mt = Utils.createControllerDataEndpointMethod(wc, (DeclaredType)repositoryType, repository.getSimpleName().toString(), method, controllerId, id, toImport);
                                wc.rewrite((Tree)clazz, (Tree)GeneratorUtilities.get((WorkingCopy)wc).insertClassMember(clazz, (Tree)mt, offset));
                                wc.rewrite((Tree)wc.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)wc).addImports(wc.getCompilationUnit(), toImport));
                            }
                        }
                    })).build();
                }
                return null;
            }

            @Override
            public Completion createFinderMethodItem(String name, String returnType, int offset) {
                CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Method).sortText(String.format("%04d%s", 10, name));
                if (returnType != null) {
                    builder.labelDetail("(...)").labelDescription(returnType).insertText("${1:" + returnType + "} " + name + "$2($0);").insertTextFormat(Completion.TextFormat.Snippet);
                }
                return builder.build();
            }

            @Override
            public Completion createFinderMethodNameItem(String prefix, String name, int offset) {
                return CompletionCollector.newBuilder((String)(prefix + name)).kind(Completion.Kind.Method).sortText(String.format("%04d%s", 10, name)).build();
            }

            @Override
            public Completion createFinderMethodParam(CompilationInfo info, VariableElement variableElement, int offset) {
                String name = variableElement.getSimpleName().toString();
                TypeMirror type = variableElement.asType();
                String typeName = Utils.getTypeName(info, type, false, false).toString();
                HashSet<ElementHandle> handles = new HashSet<ElementHandle>();
                StringBuilder sb = new StringBuilder();
                for (TypeElement ann : Utils.getRelevantAnnotations(variableElement)) {
                    sb.append('@').append(ann.getSimpleName()).append(' ');
                    handles.add(ElementHandle.create((Element)ann));
                }
                if (type.getKind() == TypeKind.DECLARED) {
                    handles.add(ElementHandle.create((Element)((TypeElement)((DeclaredType)type).asElement())));
                }
                sb.append(typeName).append(' ').append(name);
                CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Property).sortText(String.format("%04d%s", 10, name)).insertText(sb.toString()).labelDescription(typeName);
                if (!handles.isEmpty()) {
                    builder.additionalTextEdits(() -> MicronautDataCompletionCollector.modify2TextEdits(JavaSource.forFileObject((FileObject)info.getFileObject()), (Task<WorkingCopy>)copy -> {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Set toImport = handles.stream().map(handle -> (TypeElement)handle.resolve((CompilationInfo)copy)).filter(te -> te != null).collect(Collectors.toSet());
                        copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), toImport));
                    }));
                }
                return builder.build();
            }

            @Override
            public Completion createFinderMethodParams(CompilationInfo info, List<VariableElement> variableElements, int offset) {
                StringBuilder label = new StringBuilder();
                StringBuilder insertText = new StringBuilder();
                StringBuilder sortParams = new StringBuilder();
                HashSet<ElementHandle> handles = new HashSet<ElementHandle>();
                label.append('(');
                int cnt = 0;
                Iterator<VariableElement> it = variableElements.iterator();
                while (it.hasNext()) {
                    ++cnt;
                    VariableElement variableElement = it.next();
                    String name = variableElement.getSimpleName().toString();
                    TypeMirror type = variableElement.asType();
                    String typeName = Utils.getTypeName(info, type, false, false).toString();
                    for (TypeElement ann : Utils.getRelevantAnnotations(variableElement)) {
                        insertText.append('@').append(ann.getSimpleName()).append(' ');
                        handles.add(ElementHandle.create((Element)ann));
                    }
                    if (type.getKind() == TypeKind.DECLARED) {
                        handles.add(ElementHandle.create((Element)((TypeElement)((DeclaredType)type).asElement())));
                    }
                    label.append(typeName).append(' ').append(name);
                    insertText.append(typeName).append(' ').append("${").append(cnt).append(":").append(name).append("}");
                    sortParams.append(typeName);
                    if (!it.hasNext()) continue;
                    label.append(", ");
                    insertText.append(", ");
                    sortParams.append(",");
                }
                label.append(')');
                CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)label.toString()).kind(Completion.Kind.Property).sortText(String.format("%04d#%02d%s", 5, cnt, sortParams.toString())).insertText(insertText.toString()).insertTextFormat(Completion.TextFormat.Snippet);
                if (!handles.isEmpty()) {
                    builder.additionalTextEdits(() -> MicronautDataCompletionCollector.modify2TextEdits(JavaSource.forFileObject((FileObject)info.getFileObject()), (Task<WorkingCopy>)copy -> {
                        copy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        Set toImport = handles.stream().map(handle -> (TypeElement)handle.resolve((CompilationInfo)copy)).filter(te -> te != null).collect(Collectors.toSet());
                        copy.rewrite((Tree)copy.getCompilationUnit(), (Tree)GeneratorUtilities.get((WorkingCopy)copy).addImports(copy.getCompilationUnit(), toImport));
                    }));
                }
                return builder.build();
            }

            @Override
            public Completion createSQLItem(CompletionItem item) {
                return CompletionCollector.newBuilder((String)item.getInsertPrefix().toString()).insertText(item.getInsertPrefix().toString().replace("\"", "\\\"")).kind(Completion.Kind.Property).sortText(String.format("%010d%s", Long.valueOf(item.getSortPriority()) + Math.abs(Integer.MIN_VALUE), item.getSortText())).build();
            }

            @Override
            public Completion createKeywordItem(String name, int offset) {
                return CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Keyword).sortText(String.format("%04d%s", 200, name)).build();
            }

            @Override
            public Completion createBuiltInItem(String name, String parenPair, int offset) {
                return CompletionCollector.newBuilder((String)(name + parenPair.charAt(0) + "..." + parenPair.charAt(1))).kind('(' == parenPair.charAt(0) ? Completion.Kind.Function : Completion.Kind.Variable).sortText(String.format("%04d%s", 100, name)).insertText(name + parenPair.charAt(0) + "$0" + parenPair.charAt(1)).insertTextFormat(Completion.TextFormat.Snippet).build();
            }

            @Override
            public Completion createPackageItem(String name, int offset) {
                return CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Folder).sortText(String.format("%04d%s", 400, name)).insertText(name + '.').build();
            }

            @Override
            public Completion createBeanPropertyItem(String name, String typeName, int offset) {
                return CompletionCollector.newBuilder((String)(name + " : " + typeName)).kind(Completion.Kind.Property).sortText(String.format("%04d%s", 50, name)).insertText(name).build();
            }

            @Override
            public Completion createEnvPropertyItem(String name, String documentation, int anchorOffset, int offset) {
                return CompletionCollector.newBuilder((String)name).kind(Completion.Kind.Text).sortText(name).textEdit(new TextEdit(anchorOffset, offset, name)).documentation(documentation).build();
            }

            @Override
            public Completion createJavaElementItem(CompilationInfo info, Element element, int offset) {
                String simpleName = element.getSimpleName().toString();
                if (element.getKind() == ElementKind.METHOD) {
                    TypeMirror tm;
                    Iterator<? extends VariableElement> it = ((ExecutableElement)element).getParameters().iterator();
                    Iterator<? extends TypeMirror> tIt = ((ExecutableType)element.asType()).getParameterTypes().iterator();
                    StringBuilder labelDetail = new StringBuilder();
                    StringBuilder insertText = new StringBuilder();
                    StringBuilder sortParams = new StringBuilder();
                    labelDetail.append('(');
                    insertText.append(simpleName).append('(');
                    sortParams.append('(');
                    int cnt = 0;
                    boolean asTemplate = false;
                    while (it.hasNext() && tIt.hasNext() && (tm = tIt.next()) != null) {
                        ++cnt;
                        String paramTypeName = Utils.getTypeName(info, tm, false, ((ExecutableElement)element).isVarArgs() && !tIt.hasNext()).toString();
                        String paramName = it.next().getSimpleName().toString();
                        labelDetail.append(paramTypeName).append(' ').append(paramName);
                        sortParams.append(paramTypeName);
                        insertText.append("${").append(cnt).append(':').append(paramName).append('}');
                        asTemplate = true;
                        if (!tIt.hasNext()) continue;
                        labelDetail.append(", ");
                        sortParams.append(',');
                        insertText.append(", ");
                    }
                    labelDetail.append(')');
                    insertText.append(')');
                    sortParams.append(')');
                    return CompletionCollector.newBuilder((String)simpleName).kind(Completion.Kind.Method).labelDetail(labelDetail.toString()).labelDescription(Utils.getTypeName(info, ((ExecutableElement)element).getReturnType(), false, false).toString()).sortText(String.format("%04d%s#%02d%s", 100, simpleName, cnt, sortParams.toString())).insertText(insertText.toString()).insertTextFormat(asTemplate ? Completion.TextFormat.Snippet : Completion.TextFormat.PlainText).documentation(() -> MicronautExpressionLanguageUtilities.getJavadocText(info, element, false, 3)).build();
                }
                CompletionCollector.Builder builder = CompletionCollector.newBuilder((String)simpleName);
                switch (element.getKind()) {
                    case PARAMETER: {
                        builder.kind(Completion.Kind.Variable).sortText(String.format("%04d%s", 90, simpleName)).labelDescription(Utils.getTypeName(info, element.asType(), false, false).toString());
                        break;
                    }
                    case RECORD_COMPONENT: {
                        builder.kind(Completion.Kind.Field).sortText(String.format("%04d%s", 90, simpleName)).labelDescription(Utils.getTypeName(info, element.asType(), false, false).toString());
                        break;
                    }
                    case ENUM: {
                        builder.kind(Completion.Kind.Enum).sortText(String.format("%04d%s", 300, simpleName));
                        break;
                    }
                    case CLASS: {
                        builder.kind(Completion.Kind.Class).sortText(String.format("%04d%s", 300, simpleName));
                        break;
                    }
                    case RECORD: {
                        builder.kind(Completion.Kind.Struct).sortText(String.format("%04d%s", 300, simpleName));
                        break;
                    }
                    case ANNOTATION_TYPE: 
                    case INTERFACE: {
                        builder.kind(Completion.Kind.Interface).sortText(String.format("%04d%s", 300, simpleName));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected Java element kind: " + (Object)((Object)element.getKind()));
                    }
                }
                return builder.documentation(() -> MicronautExpressionLanguageUtilities.getJavadocText(info, element, false, 3)).build();
            }
        }).stream().forEach(consumer);
        return true;
    }

    private static List<TextEdit> modify2TextEdits(JavaSource js, Task<WorkingCopy> task) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        try {
            FileObject[] file = new FileObject[1];
            ModificationResult changes = js.runModificationTask(wc -> {
                task.run(wc);
                file[0] = wc.getFileObject();
            });
            List diffs = changes.getDifferences(file[0]);
            if (diffs != null) {
                for (ModificationResult.Difference diff : diffs) {
                    edits.add(new TextEdit(diff.getStartPosition().getOffset(), diff.getEndPosition().getOffset(), diff.getNewText()));
                }
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        return edits;
    }
}

