/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints;

import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.swing.JComponent;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.SuspiciousNamesCustomizer;
import org.netbeans.modules.java.hints.spi.AbstractHint;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SuspiciousNamesCombination
extends AbstractHint {
    static final String GROUP_SEPARATOR = "|";
    static final String SEPARATORS_REGEX = "[, \t;]";
    static final String GROUP_KEY = "groups";
    static final String DEFAULT_GROUPS = "x, width|y, height";
    private static final String KEY = SuspiciousNamesCombination.class.getName();

    public SuspiciousNamesCombination() {
        super(false, true, AbstractHint.HintSeverity.WARNING, new String[]{"SuspiciousNameCombination"});
    }

    public Set<Tree.Kind> getTreeKinds() {
        return EnumSet.of(Tree.Kind.METHOD_INVOCATION, Tree.Kind.ASSIGNMENT, Tree.Kind.VARIABLE);
    }

    public List<ErrorDescription> run(CompilationInfo info, TreePath treePath) {
        switch (treePath.getLeaf().getKind()) {
            case METHOD_INVOCATION: {
                return this.handleMethodInvocation(info, treePath);
            }
            case ASSIGNMENT: {
                return this.handleAssignment(info, treePath);
            }
            case VARIABLE: {
                return this.handleVariable(info, treePath);
            }
        }
        return null;
    }

    public void cancel() {
    }

    private Map<String, Integer> ensureNameMapLoaded(CompilationInfo info) {
        HashMap<String, Integer> mapNameToGroup = (HashMap<String, Integer>)info.getCachedValue((Object)KEY);
        if (mapNameToGroup != null) {
            return mapNameToGroup;
        }
        mapNameToGroup = new HashMap<String, Integer>();
        Preferences prefs = this.getPreferences(null);
        String value = prefs.get(GROUP_KEY, DEFAULT_GROUPS);
        if (value == null) {
            info.putCachedValue((Object)KEY, mapNameToGroup, CompilationInfo.CacheClearPolicy.ON_TASK_END);
            return mapNameToGroup;
        }
        String[] groups = value.split(Pattern.quote(GROUP_SEPARATOR));
        int idx = 0;
        for (String g : groups) {
            String[] names;
            for (String n : names = g.split(SEPARATORS_REGEX)) {
                if (n.isEmpty()) continue;
                mapNameToGroup.put(n.toLowerCase(), idx);
            }
            ++idx;
        }
        info.putCachedValue((Object)KEY, mapNameToGroup, CompilationInfo.CacheClearPolicy.ON_TASK_END);
        return mapNameToGroup;
    }

    public JComponent getCustomizer(Preferences node) {
        return new SuspiciousNamesCustomizer(node);
    }

    private List<ErrorDescription> handleMethodInvocation(CompilationInfo info, TreePath treePath) {
        Element el = info.getTrees().getElement(treePath);
        if (el == null || el.getKind() != ElementKind.CONSTRUCTOR && el.getKind() != ElementKind.METHOD) {
            return null;
        }
        MethodInvocationTree mit = (MethodInvocationTree)treePath.getLeaf();
        ExecutableElement ee = (ExecutableElement)el;
        if (ee.getParameters().size() != mit.getArguments().size()) {
            return null;
        }
        ArrayList<ErrorDescription> result = new ArrayList<ErrorDescription>();
        for (int cntr = 0; cntr < ee.getParameters().size(); ++cntr) {
            ExpressionTree arg;
            String actualName;
            String declarationName = ee.getParameters().get(cntr).getSimpleName().toString();
            if (!this.isConflicting(info, declarationName, actualName = SuspiciousNamesCombination.getName(arg = mit.getArguments().get(cntr)))) continue;
            long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), arg);
            long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), arg);
            if (start == -1L || end == -1L) continue;
            result.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)"Suspicious names combination", (FileObject)info.getFileObject(), (int)((int)start), (int)((int)end)));
        }
        return result;
    }

    private List<ErrorDescription> handleAssignment(CompilationInfo info, TreePath treePath) {
        String actualName;
        AssignmentTree at = (AssignmentTree)treePath.getLeaf();
        String declarationName = SuspiciousNamesCombination.getName(at.getVariable());
        if (this.isConflicting(info, declarationName, actualName = SuspiciousNamesCombination.getName(at.getExpression()))) {
            long start = info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), at.getVariable());
            long end = info.getTrees().getSourcePositions().getEndPosition(info.getCompilationUnit(), at.getVariable());
            if (start != -1L && end != -1L) {
                return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)"Suspicious names combination", (FileObject)info.getFileObject(), (int)((int)start), (int)((int)end)));
            }
        }
        return null;
    }

    private List<ErrorDescription> handleVariable(CompilationInfo info, TreePath treePath) {
        int[] span;
        String actualName;
        VariableTree vt = (VariableTree)treePath.getLeaf();
        if (vt.getName() == null) {
            return null;
        }
        String declarationName = vt.getName().toString();
        if (this.isConflicting(info, declarationName, actualName = SuspiciousNamesCombination.getName(vt.getInitializer())) && (span = info.getTreeUtilities().findNameSpan(vt)) != null) {
            String description = NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"HINT_SuspiciousNamesCombination");
            return Collections.singletonList(ErrorDescriptionFactory.createErrorDescription((Severity)this.getSeverity().toEditorSeverity(), (String)description, (FileObject)info.getFileObject(), (int)span[0], (int)span[1]));
        }
        return null;
    }

    static String getName(ExpressionTree et) {
        if (et == null) {
            return null;
        }
        switch (et.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)et).getName().toString();
            }
            case METHOD_INVOCATION: {
                return SuspiciousNamesCombination.getName(((MethodInvocationTree)et).getMethodSelect());
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)et).getIdentifier().toString();
            }
        }
        return null;
    }

    private boolean isConflicting(CompilationInfo info, String declarationName, String actualName) {
        int actualCat;
        if (declarationName == null || actualName == null) {
            return false;
        }
        int declarationCat = this.findCategory(info, declarationName);
        return declarationCat != (actualCat = this.findCategory(info, actualName)) && declarationCat != -1 && actualCat != -1;
    }

    private int findCategory(CompilationInfo info, String name) {
        Set<String> broken = SuspiciousNamesCombination.breakName(name);
        Map<String, Integer> mapNameToGroup = this.ensureNameMapLoaded(info);
        for (String s : broken) {
            Integer i = mapNameToGroup.get(s);
            if (i == null) continue;
            return i;
        }
        return -1;
    }

    static Set<String> breakName(String name) {
        int index;
        HashSet<String> result = new HashSet<String>();
        int wordStartOffset = 0;
        for (index = 0; index < name.length(); ++index) {
            if (Character.isUpperCase(name.charAt(index))) {
                if (wordStartOffset < index) {
                    result.add(name.substring(wordStartOffset, index).toLowerCase());
                }
                wordStartOffset = index;
            }
            if (name.charAt(index) != '-') continue;
            if (wordStartOffset < index) {
                result.add(name.substring(wordStartOffset, index).toLowerCase());
            }
            wordStartOffset = index + 1;
        }
        if (wordStartOffset < index) {
            result.add(name.substring(wordStartOffset, index).toLowerCase());
        }
        return result;
    }

    public String getId() {
        return SuspiciousNamesCombination.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"DN_SuspiciousNamesCombination");
    }

    public String getDescription() {
        return NbBundle.getMessage(SuspiciousNamesCombination.class, (String)"DESC_SuspiciousNamesCombination");
    }
}

