/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.api;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.lsp.client.debugger.DAPConfigurationAccessor;
import org.netbeans.modules.lsp.client.debugger.DAPDebugger;
import org.openide.util.Exceptions;

public class DAPConfiguration {
    private final InputStream in;
    private final OutputStream out;
    private Map<String, Object> configuration = new HashMap<String, Object>();
    private String sessionName = "";
    private boolean delayLaunch;

    public static DAPConfiguration create(InputStream in, OutputStream out) {
        return new DAPConfiguration(in, out);
    }

    private DAPConfiguration(InputStream in, OutputStream out) {
        this.in = in;
        this.out = out;
    }

    public DAPConfiguration addConfiguration(Map<String, Object> configuration) {
        this.configuration.putAll(configuration);
        return this;
    }

    public DAPConfiguration setSessionName(String sessionName) {
        this.sessionName = sessionName;
        return this;
    }

    public DAPConfiguration delayLaunch() {
        this.delayLaunch = true;
        return this;
    }

    public void attach() {
        try {
            DAPDebugger.startDebugger(this, DAPDebugger.Type.ATTACH);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void launch() {
        try {
            DAPDebugger.startDebugger(this, DAPDebugger.Type.LAUNCH);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    static {
        DAPConfigurationAccessor.setInstance(new DAPConfigurationAccessor(){

            @Override
            public OutputStream getOut(DAPConfiguration config) {
                return config.out;
            }

            @Override
            public InputStream getIn(DAPConfiguration config) {
                return config.in;
            }

            @Override
            public boolean getDelayLaunch(DAPConfiguration config) {
                return config.delayLaunch;
            }

            @Override
            public Map<String, Object> getConfiguration(DAPConfiguration config) {
                return config.configuration;
            }

            @Override
            public String getSessionName(DAPConfiguration config) {
                return config.sessionName;
            }
        });
    }
}

