/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class LongTermBackUpScheduleDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="repeatCadence")
    private final RepeatCadence repeatCadence;
    @JsonProperty(value="timeOfBackup")
    private final Date timeOfBackup;
    @JsonProperty(value="retentionPeriodInDays")
    private final Integer retentionPeriodInDays;
    @JsonProperty(value="isDisabled")
    private final Boolean isDisabled;

    @Deprecated
    @ConstructorProperties(value={"repeatCadence", "timeOfBackup", "retentionPeriodInDays", "isDisabled"})
    public LongTermBackUpScheduleDetails(RepeatCadence repeatCadence, Date timeOfBackup, Integer retentionPeriodInDays, Boolean isDisabled) {
        this.repeatCadence = repeatCadence;
        this.timeOfBackup = timeOfBackup;
        this.retentionPeriodInDays = retentionPeriodInDays;
        this.isDisabled = isDisabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public RepeatCadence getRepeatCadence() {
        return this.repeatCadence;
    }

    public Date getTimeOfBackup() {
        return this.timeOfBackup;
    }

    public Integer getRetentionPeriodInDays() {
        return this.retentionPeriodInDays;
    }

    public Boolean getIsDisabled() {
        return this.isDisabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("LongTermBackUpScheduleDetails(");
        sb.append("super=").append(super.toString());
        sb.append("repeatCadence=").append(String.valueOf((Object)this.repeatCadence));
        sb.append(", timeOfBackup=").append(String.valueOf(this.timeOfBackup));
        sb.append(", retentionPeriodInDays=").append(String.valueOf(this.retentionPeriodInDays));
        sb.append(", isDisabled=").append(String.valueOf(this.isDisabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LongTermBackUpScheduleDetails)) {
            return false;
        }
        LongTermBackUpScheduleDetails other = (LongTermBackUpScheduleDetails)((Object)o);
        return Objects.equals((Object)this.repeatCadence, (Object)other.repeatCadence) && Objects.equals(this.timeOfBackup, other.timeOfBackup) && Objects.equals(this.retentionPeriodInDays, other.retentionPeriodInDays) && Objects.equals(this.isDisabled, other.isDisabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.repeatCadence == null ? 43 : this.repeatCadence.hashCode());
        result = result * 59 + (this.timeOfBackup == null ? 43 : this.timeOfBackup.hashCode());
        result = result * 59 + (this.retentionPeriodInDays == null ? 43 : this.retentionPeriodInDays.hashCode());
        result = result * 59 + (this.isDisabled == null ? 43 : this.isDisabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RepeatCadence implements BmcEnum
    {
        OneTime("ONE_TIME"),
        Weekly("WEEKLY"),
        Monthly("MONTHLY"),
        Yearly("YEARLY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, RepeatCadence> map;

        private RepeatCadence(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RepeatCadence create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'RepeatCadence', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(RepeatCadence.class);
            map = new HashMap<String, RepeatCadence>();
            for (RepeatCadence v : RepeatCadence.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="repeatCadence")
        private RepeatCadence repeatCadence;
        @JsonProperty(value="timeOfBackup")
        private Date timeOfBackup;
        @JsonProperty(value="retentionPeriodInDays")
        private Integer retentionPeriodInDays;
        @JsonProperty(value="isDisabled")
        private Boolean isDisabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder repeatCadence(RepeatCadence repeatCadence) {
            this.repeatCadence = repeatCadence;
            this.__explicitlySet__.add("repeatCadence");
            return this;
        }

        public Builder timeOfBackup(Date timeOfBackup) {
            this.timeOfBackup = timeOfBackup;
            this.__explicitlySet__.add("timeOfBackup");
            return this;
        }

        public Builder retentionPeriodInDays(Integer retentionPeriodInDays) {
            this.retentionPeriodInDays = retentionPeriodInDays;
            this.__explicitlySet__.add("retentionPeriodInDays");
            return this;
        }

        public Builder isDisabled(Boolean isDisabled) {
            this.isDisabled = isDisabled;
            this.__explicitlySet__.add("isDisabled");
            return this;
        }

        public LongTermBackUpScheduleDetails build() {
            LongTermBackUpScheduleDetails model = new LongTermBackUpScheduleDetails(this.repeatCadence, this.timeOfBackup, this.retentionPeriodInDays, this.isDisabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(LongTermBackUpScheduleDetails model) {
            if (model.wasPropertyExplicitlySet("repeatCadence")) {
                this.repeatCadence(model.getRepeatCadence());
            }
            if (model.wasPropertyExplicitlySet("timeOfBackup")) {
                this.timeOfBackup(model.getTimeOfBackup());
            }
            if (model.wasPropertyExplicitlySet("retentionPeriodInDays")) {
                this.retentionPeriodInDays(model.getRetentionPeriodInDays());
            }
            if (model.wasPropertyExplicitlySet("isDisabled")) {
                this.isDisabled(model.getIsDisabled());
            }
            return this;
        }
    }
}

