/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap12.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Body;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Component;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12QName;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.impl.PartReference;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.impl.SOAP12Attribute;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.impl.SOAP12MessageBaseImpl;
import org.netbeans.modules.xml.wsdl.model.impl.Util;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Reference;
import org.w3c.dom.Element;

public class SOAP12BodyImpl
extends SOAP12MessageBaseImpl
implements SOAP12Body {
    public SOAP12BodyImpl(WSDLModel model, Element e) {
        super(model, e);
    }

    public SOAP12BodyImpl(WSDLModel model) {
        this(model, SOAP12BodyImpl.createPrefixedElement(SOAP12QName.BODY.getQName(), model));
    }

    @Override
    public void accept(SOAP12Component.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<String> getParts() {
        String s = this.getAttribute(SOAP12Attribute.PARTS);
        return s == null ? null : Util.parse(s);
    }

    @Override
    public List<Reference<Part>> getPartRefs() {
        String s = this.getAttribute(SOAP12Attribute.PARTS);
        return s == null ? null : this.parseParts(s);
    }

    @Override
    public void addPart(String part) {
        String parts = this.getAttribute(SOAP12Attribute.PARTS);
        parts = parts == null ? part : parts.trim() + " " + part;
        this.setAttribute("parts", SOAP12Attribute.PARTS, parts);
    }

    @Override
    public void addPartRef(Reference<Part> partRef) {
        this.addPart(partRef.getRefString());
    }

    @Override
    public void addPart(int index, String part) {
        List<String> parts = this.getParts();
        if (parts != null) {
            parts.add(index, part);
        } else {
            parts = Collections.singletonList(part);
        }
        this.setAttribute("parts", SOAP12Attribute.PARTS, Util.toString(parts));
    }

    @Override
    public void addPartRef(int index, Reference<Part> partRef) {
        this.addPart(index, partRef.getRefString());
    }

    @Override
    public void removePart(String part) {
        List<String> parts = this.getParts();
        if (parts != null && parts.remove(part)) {
            this.setAttribute("parts", SOAP12Attribute.PARTS, Util.toString(parts));
        }
    }

    @Override
    public void removePartRef(Reference<Part> partRef) {
        this.removePart(partRef.getRefString());
    }

    @Override
    public void setParts(List<String> parts) {
        this.setAttribute("parts", SOAP12Attribute.PARTS, Util.toString(parts));
    }

    @Override
    public void setPartRefs(List<Reference<Part>> parts) {
        String value = null;
        if (parts != null && !parts.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Reference<Part> ref : parts) {
                sb.append(ref.getRefString());
            }
            value = sb.toString();
        }
        this.setAttribute("parts", SOAP12Attribute.PARTS, value);
    }

    private List<Reference<Part>> parseParts(String s) {
        ArrayList<Reference<Part>> ret = new ArrayList<Reference<Part>>();
        for (String part : Util.parse(s)) {
            ret.add(new PartReference(this, part));
        }
        return ret;
    }

    @Override
    public boolean canBeAddedTo(Component target) {
        return target instanceof BindingInput || target instanceof BindingOutput;
    }
}

