/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.glassfish.javaee.db.JDBCConnectionPool;
import org.netbeans.modules.glassfish.javaee.db.JDBCResource;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.payara.tooling.TaskState;
import org.netbeans.modules.payara.tooling.admin.CommandGetProperty;
import org.netbeans.modules.payara.tooling.admin.ResultMap;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.netbeans.modules.payara.tooling.utils.StringPrefixTree;

public class DataSourcesReader {
    public static final String DATA_SOURCES_PATTERN = "resources.*";
    public static final String PROPERTY_SPLIT_PATTERN = "\\.";
    public static final String PROPERTY_IDENT = "property";
    static final String DEFAULT_DATA_SOURCE = "jdbc/__default";
    static final String DEFAULT_DATA_SOURCE_EE7 = "java:comp/DefaultDataSource";
    private final PayaraServer server;

    public DataSourcesReader(PayaraServer server) {
        this.server = server;
    }

    public Set<Datasource> getDataSourcesFromServer() {
        Map<String, String> properties = this.getPropertiesFromServer();
        if (properties != null) {
            HashMap<String, JDBCConnectionPool> pools = new HashMap<String, JDBCConnectionPool>();
            HashMap<String, JDBCResource> resources = new HashMap<String, JDBCResource>();
            this.buildJDBCContentObjects(properties, pools, resources);
            this.assignConnectionPoolsToResources(pools, resources);
            if (this.server.getPlatformVersion().isEE7Supported()) {
                this.addNewJavaEE7dataSource(resources);
            }
            return new HashSet<Datasource>(resources.values());
        }
        return null;
    }

    private void buildJDBCContentObjects(Map<String, String> properties, Map<String, JDBCConnectionPool> pools, Map<String, JDBCResource> resources) {
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String[] elements;
            String key = entry.getKey();
            if (key == null || key.length() <= 0 || (elements = key.split(PROPERTY_SPLIT_PATTERN)).length < 4) continue;
            ResourceType type = ResourceType.toValue(elements[1]);
            switch (type) {
                case CONNECTION_POOL: {
                    this.buildJDBCConnectionPool(pools, elements, entry.getValue());
                    break;
                }
                case DATA_SOURCE: {
                    this.buildJDBCResource(resources, elements, entry.getValue());
                }
            }
        }
    }

    private void assignConnectionPoolsToResources(Map<String, JDBCConnectionPool> pools, Map<String, JDBCResource> resources) {
        for (Map.Entry<String, JDBCResource> entry : resources.entrySet()) {
            JDBCResource resource = entry.getValue();
            if (resource == null || resource.getPoolName() == null) continue;
            resource.setPool(pools.get(resource.getPoolName()));
        }
    }

    private void addNewJavaEE7dataSource(Map<String, JDBCResource> resources) {
        JDBCResource defaultResource = resources.get(DEFAULT_DATA_SOURCE);
        if (defaultResource != null && !resources.containsKey(DEFAULT_DATA_SOURCE_EE7)) {
            resources.put(DEFAULT_DATA_SOURCE_EE7, defaultResource.copy(DEFAULT_DATA_SOURCE_EE7));
        }
    }

    private void buildJDBCConnectionPool(Map<String, JDBCConnectionPool> pools, String[] elements, String attributeValue) {
        JDBCConnectionPool.PropertyType propertyType = null;
        String name = elements[2];
        switch (elements.length) {
            case 4: {
                propertyType = null;
                break;
            }
            case 5: {
                propertyType = PROPERTY_IDENT.equalsIgnoreCase(elements[3]) ? JDBCConnectionPool.PropertyType.toValue((String)elements[4]) : null;
            }
        }
        if (propertyType != null && propertyType != JDBCConnectionPool.PropertyType.UNKNOWN) {
            JDBCConnectionPool pool = this.getJDBCConnectionPool(pools, name);
            pool.setProperty(propertyType, attributeValue);
        }
    }

    private void buildJDBCResource(Map<String, JDBCResource> resources, String[] elements, String attributeValue) {
        JDBCResource.AttrType attrType = null;
        String name = elements[2];
        if (elements.length == 4) {
            attrType = JDBCResource.AttrType.toValue((String)elements[3]);
        }
        if (attrType != null && attrType != JDBCResource.AttrType.UNKNOWN) {
            JDBCResource resource = this.getJDBCResource(resources, name);
            resource.setProperty(attrType, attributeValue);
        }
    }

    private JDBCConnectionPool getJDBCConnectionPool(Map<String, JDBCConnectionPool> pools, String name) {
        JDBCConnectionPool pool = pools.get(name);
        if (pool == null) {
            pool = new JDBCConnectionPool();
            pools.put(name, pool);
        }
        return pool;
    }

    private JDBCResource getJDBCResource(Map<String, JDBCResource> resources, String name) {
        JDBCResource resource = resources.get(name);
        if (resource == null) {
            resource = new JDBCResource();
            resources.put(name, resource);
        }
        return resource;
    }

    private Map<String, String> getPropertiesFromServer() {
        ResultMap result = CommandGetProperty.getProperties((PayaraServer)this.server, (String)DATA_SOURCES_PATTERN);
        if (result != null && result.getState() == TaskState.COMPLETED) {
            return result.getValue();
        }
        return null;
    }

    private static enum ResourceType {
        UNKNOWN,
        CONNECTION_POOL,
        DATA_SOURCE;

        private static final String UNKNOWN_STR = "UNKNOWN";
        private static final String CONNECTION_POOL_STR = "jdbc-connection-pool";
        private static final String DATA_SOURCE_STR = "jdbc-resource";
        private static final StringPrefixTree<ResourceType> stringValues;

        public static ResourceType toValue(String name) {
            if (name != null) {
                ResourceType type = (ResourceType)((Object)stringValues.match((CharSequence)name.toLowerCase()));
                return type != null ? type : UNKNOWN;
            }
            return null;
        }

        public String toString() {
            switch (this) {
                case UNKNOWN: {
                    return UNKNOWN_STR;
                }
                case CONNECTION_POOL: {
                    return CONNECTION_POOL_STR;
                }
                case DATA_SOURCE: {
                    return DATA_SOURCE_STR;
                }
            }
            throw new IllegalStateException("Invalid ResourceType value");
        }

        static {
            stringValues = new StringPrefixTree(false);
            stringValues.add(CONNECTION_POOL.toString(), (Object)CONNECTION_POOL);
            stringValues.add(DATA_SOURCE.toString(), (Object)DATA_SOURCE);
        }
    }
}

