/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty;

import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.smarty.SmartyPhpModuleCustomizerExtender;
import org.netbeans.modules.php.smarty.ui.options.SmartyOptions;
import org.openide.filesystems.FileObject;

public class SmartyFramework {
    public static final String BASE_CLASS_NAME = "Smarty";
    public static final String OPEN_DELIMITER = "{";
    public static final String CLOSE_DELIMITER = "}";
    private static String delimiterDefaultOpen = SmartyOptions.getInstance().getDefaultOpenDelimiter();
    private static String delimiterDefaultClose = SmartyOptions.getInstance().getDefaultCloseDelimiter();
    private static Version smartyVersion = Version.SMARTY3;
    private static ToggleCommentOption toggleCommentOption = ToggleCommentOption.SMARTY;

    public static String getCloseDelimiter(FileObject fileObject) {
        PhpModule phpModule = PhpModule.Factory.forFileObject((FileObject)fileObject);
        if (phpModule != null && !SmartyPhpModuleCustomizerExtender.getCustomCloseDelimiter(phpModule).isEmpty()) {
            return SmartyPhpModuleCustomizerExtender.getCustomCloseDelimiter(phpModule);
        }
        return delimiterDefaultClose;
    }

    public static String getOpenDelimiter(FileObject fileObject) {
        PhpModule phpModule = PhpModule.Factory.forFileObject((FileObject)fileObject);
        if (phpModule != null && !SmartyPhpModuleCustomizerExtender.getCustomOpenDelimiter(phpModule).isEmpty()) {
            return SmartyPhpModuleCustomizerExtender.getCustomOpenDelimiter(phpModule);
        }
        return delimiterDefaultOpen;
    }

    public static String getDelimiterDefaultOpen() {
        return delimiterDefaultOpen;
    }

    public static String getDelimiterDefaultClose() {
        return delimiterDefaultClose;
    }

    public static void setDelimiterDefaultClose(String delimiterDefaultClose) {
        SmartyFramework.delimiterDefaultClose = delimiterDefaultClose;
    }

    public static void setDelimiterDefaultOpen(String delimiterDefaultOpen) {
        SmartyFramework.delimiterDefaultOpen = delimiterDefaultOpen;
    }

    public static void setSmartyVersion(Version version) {
        smartyVersion = version;
    }

    public static void setToggleCommentOption(ToggleCommentOption toggleCommentOption) {
        SmartyFramework.toggleCommentOption = toggleCommentOption;
    }

    public static enum Version {
        SMARTY3,
        SMARTY2;

    }

    public static enum ToggleCommentOption {
        SMARTY,
        CONTEXT;

    }
}

