/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.print;

import com.projectlibre1.pm.task.Project;
import com.projectlibre1.print.ExtendedPageFormat;
import com.projectlibre1.print.FitToSettings;
import com.projectlibre1.print.GanttSettings;
import com.projectlibre1.print.PDFPrintService;
import com.projectlibre1.print.PrintPreviewFrame;
import com.projectlibre1.print.PrintSettings;
import com.projectlibre1.print.PrintSettingsManager;
import com.projectlibre1.print.ScaleToSettings;
import com.projectlibre1.print.ScalingSettings;
import com.projectlibre1.print.ViewSettings;
import java.awt.geom.AffineTransform;
import java.awt.print.Pageable;
import java.util.ArrayList;
import java.util.Iterator;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;

public abstract class PrintDocument
implements Pageable {
    public static final double DEFAULT_ZOOM = 0.77;
    protected ExtendedPageFormat pageFormat;
    protected PrintService[] printServices;
    protected PrintService[] realPrintServices;
    protected PrintService printService;
    protected PDFPrintService pdfPrintService;
    protected PrintPreviewFrame printPreview;
    protected PrintSettings printSettings;
    boolean scaleToSelected = true;
    ScaleToSettings scaleToSettings = null;
    FitToSettings fitToSettings = null;
    boolean showSpreadsheet = true;
    boolean showGantt = true;
    protected double svgZoomX;
    protected double svgZoomY;
    protected double zoomX = 1.0;
    protected double zoomY = 1.0;

    public PrintDocument(Project project, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ArrayList<ScalingSettings> arrayList;
        int n;
        Object object;
        this.printSettings = PrintSettingsManager.getSettings(bl4 ? null : project);
        this.pdfPrintService = new PDFPrintService();
        if (bl) {
            this.realPrintServices = new PrintService[0];
            this.printServices = new PrintService[]{this.pdfPrintService};
            this.setPrintService(this.pdfPrintService, true);
        } else {
            this.realPrintServices = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            object = PrintServiceLookup.lookupDefaultPrintService();
            if (this.realPrintServices.length == 0 && object != null) {
                this.realPrintServices = new PrintService[]{object};
            }
            this.printServices = new PrintService[this.realPrintServices.length + 1];
            this.printServices[0] = this.pdfPrintService;
            for (int i = 0; i < this.realPrintServices.length; ++i) {
                this.printServices[i + 1] = this.realPrintServices[i];
            }
            if (!bl2 && bl3) {
                object = this.pdfPrintService;
            }
            if (!bl2 && this.printSettings.isPdfService()) {
                object = this.pdfPrintService;
            } else if (this.printSettings.getPrintServiceName() != null) {
                PrintService printService = null;
                for (n = 0; n < this.printServices.length; ++n) {
                    if (!this.printSettings.getPrintServiceName().equals(this.printServices[n].getName())) continue;
                    printService = this.printServices[n];
                    break;
                }
                if (printService != null) {
                    object = printService;
                }
            }
            this.setPrintService((PrintService)(object == null ? this.pdfPrintService : object), true);
        }
        object = this.printSettings.getViewSettings();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ViewSettings viewSettings = (ViewSettings)iterator.next();
                if (!(viewSettings instanceof GanttSettings)) continue;
                GanttSettings ganttSettings = (GanttSettings)viewSettings;
                this.showGantt = ganttSettings.isGanttVisible();
                this.showSpreadsheet = ganttSettings.isSpreadSheetVisible();
            }
        }
        if ((arrayList = this.printSettings.getScalingSettings()) != null) {
            n = 0;
            for (ScalingSettings scalingSettings : arrayList) {
                if (scalingSettings instanceof ScaleToSettings) {
                    this.scaleToSettings = (ScaleToSettings)scalingSettings;
                    if (this.printSettings.scalingIndex == n) {
                        this.scaleToSelected = true;
                    }
                } else if (scalingSettings instanceof FitToSettings) {
                    this.fitToSettings = (FitToSettings)scalingSettings;
                    if (this.printSettings.scalingIndex == n) {
                        this.scaleToSelected = false;
                    }
                }
                ++n;
            }
        }
        if (this.scaleToSettings == null) {
            this.scaleToSettings = new ScaleToSettings();
        }
        if (this.fitToSettings == null) {
            this.fitToSettings = new FitToSettings();
        }
    }

    public PrintService[] getPrintServices() {
        return this.printServices;
    }

    public PrintService getPrintService() {
        return this.printService;
    }

    public void setPrintService(PrintService printService, boolean bl) {
        Cloneable cloneable;
        this.printService = printService;
        if (bl && this.printSettings != null && this.pageFormat != null && (cloneable = this.printSettings.getPageFormat()) != null) {
            ((ExtendedPageFormat)cloneable).copy(this.pageFormat);
        }
        if (this.pageFormat == null) {
            try {
                if (this.printSettings.isEmpty() || this.printSettings.getPageFormat() == null) {
                    cloneable = this.getDefaultMediaSizeName();
                    MediaPrintableArea mediaPrintableArea = this.getDefaultMediaPrintableArea((MediaSizeName)cloneable);
                    this.pageFormat = new ExtendedPageFormat((MediaSizeName)cloneable, mediaPrintableArea);
                } else {
                    this.pageFormat = (ExtendedPageFormat)this.printSettings.getPageFormat().clone();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.pageFormat == null) {
            this.pageFormat = new ExtendedPageFormat();
        }
        if (this.printSettings.isEmpty()) {
            this.printSettings.setPdfService(printService instanceof PDFPrintService);
            this.printSettings.setPrintServiceName(printService.getName());
            this.printSettings.setPageFormat(this.pageFormat);
            this.printSettings.setEmpty(false);
        }
    }

    public MediaSizeName getDefaultMediaSizeName() {
        return ExtendedPageFormat.getDefaultMediaSizeName(this.printService);
    }

    public MediaPrintableArea getDefaultMediaPrintableArea(MediaSizeName mediaSizeName) {
        return ExtendedPageFormat.getDefaultMediaPrintableArea(this.printService, mediaSizeName);
    }

    public ExtendedPageFormat getPageFormat() {
        return this.pageFormat;
    }

    public abstract void print();

    public int getColumnCount() {
        return 1;
    }

    public void update() {
    }

    public double getZoomX() {
        return this.zoomX;
    }

    public void setZoomX(double d) {
        this.zoomX = d;
    }

    public double getZoomY() {
        return this.zoomY;
    }

    public void setZoomY(double d) {
        this.zoomY = d;
    }

    public double getTotalZoomX() {
        return this.zoomX * 0.77;
    }

    public void setTotalZoomX(double d) {
        this.zoomX = d / 0.77;
    }

    public double getTotalZoomY() {
        return this.zoomY * 0.77;
    }

    public void setTotalZoomY(double d) {
        this.zoomY = d / 0.77;
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.zoomX * 0.77, 0.0, 0.0, this.zoomY * 0.77, this.pageFormat.getImageableX(), this.pageFormat.getImageableY());
    }

    public PrintSettings getPrintSettings() {
        return this.printSettings;
    }

    public FitToSettings getFitToSettings() {
        return this.fitToSettings;
    }

    public void setFitToSettings(FitToSettings fitToSettings) {
        this.fitToSettings = fitToSettings;
    }

    public boolean isScaleToSelected() {
        return this.scaleToSelected;
    }

    public void setScaleToSelected(boolean bl) {
        this.scaleToSelected = bl;
    }

    public ScaleToSettings getScaleToSettings() {
        return this.scaleToSettings;
    }

    public void setScaleToSettings(ScaleToSettings scaleToSettings) {
        this.scaleToSettings = scaleToSettings;
    }

    public boolean isShowGantt() {
        return this.showGantt;
    }

    public void setShowGantt(boolean bl) {
        this.showGantt = bl;
    }

    public boolean isShowSpreadsheet() {
        return this.showSpreadsheet;
    }

    public void setShowSpreadsheet(boolean bl) {
        this.showSpreadsheet = bl;
    }

    public double getSvgZoomX() {
        return this.svgZoomX;
    }

    public double getSvgZoomY() {
        return this.svgZoomY;
    }

    public void saveZoom() {
        this.svgZoomX = this.zoomX;
        this.svgZoomY = this.zoomY;
    }

    public void restoreZoom() {
        this.zoomX = this.svgZoomX;
        this.zoomY = this.svgZoomY;
    }

    public PDFPrintService getPdfPrintService() {
        return this.pdfPrintService;
    }
}

