/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TimeProvider;
import io.grpc.xds.GrpcBootstrapperImpl;
import io.grpc.xds.GrpcXdsTransportFactory;
import io.grpc.xds.MessagePrinter;
import io.grpc.xds.XdsClientPoolFactory;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsClientImpl;
import io.grpc.xds.client.XdsInitializationException;
import io.grpc.xds.internal.security.TlsContextManagerImpl;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsClientPoolFactory {
    private static final boolean LOG_XDS_NODE_ID = Boolean.parseBoolean(System.getenv("GRPC_LOG_XDS_NODE_ID"));
    private static final Logger log = Logger.getLogger(XdsClientImpl.class.getName());
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private final AtomicReference<Map<String, ?>> bootstrapOverride = new AtomicReference();
    private volatile ObjectPool<XdsClient> xdsClientPool;

    SharedXdsClientPoolProvider() {
        this(new GrpcBootstrapperImpl());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    @Override
    public void setBootstrapOverride(Map<String, ?> bootstrap) {
        this.bootstrapOverride.set(bootstrap);
    }

    @Override
    @Nullable
    public ObjectPool<XdsClient> get() {
        return this.xdsClientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getOrCreate() throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.xdsClientPool;
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.xdsClientPool;
                if (ref == null) {
                    Map<String, ?> rawBootstrap = this.bootstrapOverride.get();
                    Bootstrapper.BootstrapInfo bootstrapInfo = rawBootstrap != null ? this.bootstrapper.bootstrap(rawBootstrap) : this.bootstrapper.bootstrap();
                    if (bootstrapInfo.servers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    ref = this.xdsClientPool = new RefCountedXdsClientObjectPool(bootstrapInfo);
                }
            }
        }
        return ref;
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final Bootstrapper.BootstrapInfo bootstrapInfo;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo) {
            this.bootstrapInfo = (Bootstrapper.BootstrapInfo)Preconditions.checkNotNull((Object)bootstrapInfo);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    if (LOG_XDS_NODE_ID) {
                        log.log(Level.INFO, "xDS node ID: {0}", this.bootstrapInfo.node().getId());
                    }
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = new XdsClientImpl(GrpcXdsTransportFactory.DEFAULT_XDS_TRANSPORT_FACTORY, this.bootstrapInfo, this.scheduler, (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER, TimeProvider.SYSTEM_TIME_PROVIDER, MessagePrinter.INSTANCE, new TlsContextManagerImpl(this.bootstrapInfo));
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.scheduler = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)GrpcUtil.TIMER_SERVICE, (Object)this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

