/*
 * Decompiled with CFR 0.152.
 */
package com.tdunning.math.stats;

import java.util.Collection;
import java.util.List;

public class Dist {
    public static double cdf(double x, double[] data) {
        return Dist.cdf(x, data, 0.5);
    }

    public static double cdf(double x, double[] data, double w) {
        int n1 = 0;
        int n2 = 0;
        double[] dArray = data;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double v = dArray[i];
            n1 += v < x ? 1 : 0;
            n2 += v == x ? 1 : 0;
        }
        return ((double)n1 + w * (double)n2) / (double)data.length;
    }

    public static double cdf(double x, Collection<Double> data) {
        return Dist.cdf(x, data, 0.5);
    }

    public static double cdf(double x, Collection<Double> data, double w) {
        int n1 = 0;
        int n2 = 0;
        for (Double v : data) {
            n1 += v < x ? 1 : 0;
            n2 += v == x ? 1 : 0;
        }
        return ((double)n1 + w * (double)n2) / (double)data.size();
    }

    public static double quantile(double q, double[] data) {
        int n = data.length;
        if (n == 0) {
            return Double.NaN;
        }
        double index = q * (double)n;
        if (index < 0.0) {
            index = 0.0;
        }
        if (index > (double)(n - 1)) {
            index = n - 1;
        }
        return data[(int)Math.floor(index)];
    }

    public static double quantile(double q, List<Double> data) {
        int n = data.size();
        if (n == 0) {
            return Double.NaN;
        }
        double index = q * (double)n;
        if (index < 0.0) {
            index = 0.0;
        }
        if (index > (double)(n - 1)) {
            index = n - 1;
        }
        return data.get((int)Math.floor(index));
    }
}

