/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.encoding;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.FieldValue;
import com.google.cloud.firestore.annotation.DocumentId;
import com.google.cloud.firestore.annotation.IgnoreExtraProperties;
import com.google.cloud.firestore.annotation.PropertyName;
import com.google.cloud.firestore.annotation.ServerTimestamp;
import com.google.cloud.firestore.annotation.ThrowOnExtraProperties;
import com.google.cloud.firestore.encoding.CustomClassMapper;
import com.google.cloud.firestore.encoding.DeserializeContext;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;

abstract class BeanMapper<T> {
    private final Class<T> clazz;
    private final boolean throwOnUnknownProperties;
    private final boolean warnOnUnknownProperties;
    final HashSet<String> serverTimestamps;
    final HashSet<String> documentIdPropertyNames;

    BeanMapper(Class<T> clazz) {
        this.clazz = clazz;
        this.throwOnUnknownProperties = clazz.isAnnotationPresent(ThrowOnExtraProperties.class);
        this.warnOnUnknownProperties = !clazz.isAnnotationPresent(IgnoreExtraProperties.class);
        this.serverTimestamps = new HashSet();
        this.documentIdPropertyNames = new HashSet();
    }

    Class<T> getClazz() {
        return this.clazz;
    }

    boolean isThrowOnUnknownProperties() {
        return this.throwOnUnknownProperties;
    }

    boolean isWarnOnUnknownProperties() {
        return this.warnOnUnknownProperties;
    }

    abstract Map<String, Object> serialize(T var1, DeserializeContext.ErrorPath var2);

    abstract T deserialize(Map<String, Object> var1, Map<TypeVariable<Class<T>>, Type> var2, DeserializeContext var3);

    T deserialize(Map<String, Object> values, DeserializeContext context) {
        return this.deserialize(values, Collections.emptyMap(), context);
    }

    protected void verifyValidType(T object) {
        if (!this.clazz.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException("Can't serialize object of class " + object.getClass() + " with BeanMapper for class " + this.clazz);
        }
    }

    protected Type resolveType(Type type, Map<TypeVariable<Class<T>>, Type> types) {
        if (type instanceof TypeVariable) {
            Type resolvedType = types.get(type);
            if (resolvedType == null) {
                throw new IllegalStateException("Could not resolve type " + type);
            }
            return resolvedType;
        }
        return type;
    }

    protected void checkForDocIdConflict(String docIdPropertyName, Collection<String> deserializedProperties, DeserializeContext context) {
        if (deserializedProperties.contains(docIdPropertyName)) {
            String message = "'" + docIdPropertyName + "' was found from document " + context.documentRef.getPath() + ", cannot apply @DocumentId on this property for class " + this.clazz.getName();
            throw new RuntimeException(message);
        }
    }

    protected Object getSerializedValue(String property, Object propertyValue, DeserializeContext.ErrorPath path) {
        if (this.serverTimestamps.contains(property) && propertyValue == null) {
            return FieldValue.serverTimestamp();
        }
        return CustomClassMapper.serialize(propertyValue, path.child(property));
    }

    protected void applyFieldAnnotations(Field field) {
        Class<?> fieldType = field.getType();
        if (field.isAnnotationPresent(ServerTimestamp.class)) {
            this.validateServerTimestampType("Field", "is", fieldType);
            this.serverTimestamps.add(this.propertyName(field));
        }
        if (field.isAnnotationPresent(DocumentId.class)) {
            this.validateDocumentIdType("Field", "is", fieldType);
            this.documentIdPropertyNames.add(this.propertyName(field));
        }
    }

    protected void validateDocumentIdType(String fieldDescription, String operation, Type type) {
        if (type != String.class && type != DocumentReference.class) {
            throw new IllegalArgumentException(fieldDescription + " is annotated with @DocumentId but " + operation + " " + type + " instead of String or DocumentReference.");
        }
    }

    protected void validateServerTimestampType(String fieldDescription, String operation, Type type) {
        if (type != Date.class && type != Timestamp.class && type != Instant.class) {
            throw new IllegalArgumentException(fieldDescription + " is annotated with @ServerTimestamp but " + operation + " " + type + " instead of Date, Timestamp, or Instant.");
        }
    }

    protected String propertyName(Field field) {
        String annotatedName = this.annotatedName(field);
        return annotatedName != null ? annotatedName : field.getName();
    }

    protected String annotatedName(AccessibleObject obj) {
        if (obj.isAnnotationPresent(PropertyName.class)) {
            PropertyName annotation = obj.getAnnotation(PropertyName.class);
            return annotation.value();
        }
        return null;
    }

    protected void hardAssert(boolean assertion, String message) {
        if (!assertion) {
            throw new RuntimeException("Hard assert failed: " + message);
        }
    }
}

