/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.InputStream;
import org.gradle.api.internal.tasks.userinput.UserInputReader;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.daemon.client.clientinput.DaemonClientInputForwarder;
import org.gradle.internal.daemon.clientinput.ClientInputForwarder;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.events.ReadStdInEvent;
import org.gradle.launcher.daemon.protocol.CloseInput;
import org.gradle.launcher.daemon.protocol.ForwardInput;
import org.gradle.launcher.daemon.protocol.UserResponse;
import org.gradle.launcher.exec.BuildActionExecutor;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;

public class ForwardStdInToThisProcess
implements BuildActionExecutor<BuildActionParameters, BuildRequestContext> {
    private final GlobalUserInputReceiver userInputReceiver;
    private final UserInputReader userInputReader;
    private final InputStream finalStandardInput;
    private final BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate;

    public ForwardStdInToThisProcess(GlobalUserInputReceiver userInputReceiver, UserInputReader userInputReader, InputStream finalStandardInput, BuildActionExecutor<BuildActionParameters, BuildRequestContext> delegate) {
        this.userInputReceiver = userInputReceiver;
        this.userInputReader = userInputReader;
        this.finalStandardInput = finalStandardInput;
        this.delegate = delegate;
    }

    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext buildRequestContext) {
        ClientInputForwarder forwarder = new ClientInputForwarder(this.userInputReader, event -> {
            if (!(event instanceof ReadStdInEvent)) {
                throw new IllegalArgumentException();
            }
            this.userInputReceiver.readAndForwardStdin((ReadStdInEvent)event);
        });
        return (BuildActionResult)forwarder.forwardInput(stdinHandler -> {
            DaemonClientInputForwarder inputForwarder = new DaemonClientInputForwarder(this.finalStandardInput, message -> {
                if (message instanceof UserResponse) {
                    stdinHandler.onUserResponse((UserResponse)message);
                } else if (message instanceof ForwardInput) {
                    stdinHandler.onInput((ForwardInput)message);
                } else if (message instanceof CloseInput) {
                    stdinHandler.onEndOfInput();
                } else {
                    throw new IllegalArgumentException();
                }
            }, this.userInputReceiver);
            try {
                BuildActionResult buildActionResult = this.delegate.execute(action, (Object)actionParameters, (Object)buildRequestContext);
                return buildActionResult;
            }
            finally {
                inputForwarder.stop();
                stdinHandler.onEndOfInput();
            }
        });
    }
}

