/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.layouter.style.functions.values;

import org.jfree.layouting.LayoutProcess;
import org.jfree.layouting.input.style.values.CSSColorValue;
import org.jfree.layouting.input.style.values.CSSFunctionValue;
import org.jfree.layouting.input.style.values.CSSNumericType;
import org.jfree.layouting.input.style.values.CSSNumericValue;
import org.jfree.layouting.input.style.values.CSSStringValue;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.model.LayoutElement;
import org.jfree.layouting.layouter.style.functions.FunctionEvaluationException;
import org.jfree.layouting.layouter.style.functions.FunctionUtilities;
import org.jfree.layouting.layouter.style.functions.values.StyleValueFunction;

public class RgbValueFunction
implements StyleValueFunction {
    protected int validateParameter(CSSValue cSSValue) throws FunctionEvaluationException {
        CSSNumericValue cSSNumericValue;
        if (cSSValue instanceof CSSStringValue) {
            CSSStringValue cSSStringValue = (CSSStringValue)cSSValue;
            cSSNumericValue = FunctionUtilities.parseNumberValue(cSSStringValue.getValue());
        } else {
            if (!(cSSValue instanceof CSSNumericValue)) {
                throw new FunctionEvaluationException("Expected a number");
            }
            cSSNumericValue = (CSSNumericValue)cSSValue;
        }
        if (cSSNumericValue.getType().equals(CSSNumericType.NUMBER)) {
            return (int)(cSSNumericValue.getValue() % 256.0);
        }
        if (cSSNumericValue.getType().equals(CSSNumericType.PERCENTAGE)) {
            return (int)(cSSNumericValue.getValue() * 256.0 / 100.0);
        }
        throw new FunctionEvaluationException("Expected a number, not a length");
    }

    @Override
    public CSSValue evaluate(LayoutProcess layoutProcess, LayoutElement layoutElement, CSSFunctionValue cSSFunctionValue) throws FunctionEvaluationException {
        CSSValue[] cSSValueArray = cSSFunctionValue.getParameters();
        if (cSSValueArray.length == 3) {
            int n = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]));
            int n2 = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[1]));
            int n3 = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[2]));
            return new CSSColorValue(n, n2, n3);
        }
        if (cSSValueArray.length == 4) {
            int n = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[0]));
            int n4 = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[1]));
            int n5 = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[2]));
            int n6 = this.validateParameter(FunctionUtilities.resolveParameter(layoutProcess, layoutElement, cSSValueArray[3]));
            return new CSSColorValue(n, n4, n5, n6);
        }
        throw new FunctionEvaluationException("Expected either three or four parameters.");
    }
}

