/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrActionSet;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrActiveActionSet
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ACTIONSET;
    public static final int SUBACTIONPATH;

    public XrActiveActionSet(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrActiveActionSet.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="XrActionSet")
    public long actionSet() {
        return XrActiveActionSet.nactionSet(this.address());
    }

    @NativeType(value="XrPath")
    public long subactionPath() {
        return XrActiveActionSet.nsubactionPath(this.address());
    }

    public XrActiveActionSet actionSet(XrActionSet value) {
        XrActiveActionSet.nactionSet(this.address(), value);
        return this;
    }

    public XrActiveActionSet subactionPath(@NativeType(value="XrPath") long value) {
        XrActiveActionSet.nsubactionPath(this.address(), value);
        return this;
    }

    public XrActiveActionSet set(XrActionSet actionSet, long subactionPath) {
        this.actionSet(actionSet);
        this.subactionPath(subactionPath);
        return this;
    }

    public XrActiveActionSet set(XrActiveActionSet src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrActiveActionSet malloc() {
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrActiveActionSet calloc() {
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrActiveActionSet create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrActiveActionSet create(long address) {
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)address);
    }

    @Nullable
    public static XrActiveActionSet createSafe(long address) {
        return address == 0L ? null : (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrActiveActionSet.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrActiveActionSet.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrActiveActionSet malloc(MemoryStack stack) {
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrActiveActionSet calloc(MemoryStack stack) {
        return (XrActiveActionSet)XrActiveActionSet.wrap(XrActiveActionSet.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrActiveActionSet.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static long nactionSet(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET));
    }

    public static long nsubactionPath(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUBACTIONPATH);
    }

    public static void nactionSet(long struct, XrActionSet value) {
        MemoryUtil.memPutAddress((long)(struct + (long)ACTIONSET), (long)value.address());
    }

    public static void nsubactionPath(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SUBACTIONPATH, value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)ACTIONSET)));
    }

    static {
        Struct.Layout layout = XrActiveActionSet.__struct((Struct.Member[])new Struct.Member[]{XrActiveActionSet.__member((int)POINTER_SIZE), XrActiveActionSet.__member((int)8)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ACTIONSET = layout.offsetof(0);
        SUBACTIONPATH = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrActiveActionSet, Buffer>
    implements NativeResource {
        private static final XrActiveActionSet ELEMENT_FACTORY = XrActiveActionSet.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrActiveActionSet getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="XrActionSet")
        public long actionSet() {
            return XrActiveActionSet.nactionSet(this.address());
        }

        @NativeType(value="XrPath")
        public long subactionPath() {
            return XrActiveActionSet.nsubactionPath(this.address());
        }

        public Buffer actionSet(XrActionSet value) {
            XrActiveActionSet.nactionSet(this.address(), value);
            return this;
        }

        public Buffer subactionPath(@NativeType(value="XrPath") long value) {
            XrActiveActionSet.nsubactionPath(this.address(), value);
            return this;
        }
    }
}

