/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.websocket.jakarta.common;

import jakarta.websocket.EncodeException;
import jakarta.websocket.Encoder;
import jakarta.websocket.RemoteEndpoint;
import jakarta.websocket.SendHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.time.Duration;
import org.eclipse.jetty.ee10.websocket.jakarta.common.JakartaWebSocketSession;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.OutgoingEntry;
import org.eclipse.jetty.websocket.core.OutgoingFrames;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.messages.MessageOutputStream;
import org.eclipse.jetty.websocket.core.messages.MessageWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JakartaWebSocketRemoteEndpoint
implements RemoteEndpoint,
OutgoingFrames {
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketRemoteEndpoint.class);
    protected final JakartaWebSocketSession session;
    private final CoreSession coreSession;
    protected boolean batch = false;
    protected byte messageType = (byte)-1;
    protected long messageWriteTimeout = -1L;

    protected JakartaWebSocketRemoteEndpoint(JakartaWebSocketSession session, CoreSession coreSession) {
        this.session = session;
        this.coreSession = coreSession;
    }

    protected MessageWriter newMessageWriter() {
        return new MessageWriter(this.coreSession, this.session.getContainerImpl().getByteBufferPool());
    }

    protected MessageOutputStream newMessageOutputStream() {
        return new MessageOutputStream(this.coreSession, this.session.getContainerImpl().getByteBufferPool());
    }

    public void flushBatch() throws IOException {
        FutureCallback b = new FutureCallback();
        this.coreSession.flush((Callback)b);
        b.block();
    }

    public boolean getBatchingAllowed() {
        return this.batch;
    }

    public void setBatchingAllowed(boolean allowed) throws IOException {
        if (this.batch && !allowed) {
            this.flushBatch();
        }
        this.batch = allowed;
    }

    public long getIdleTimeout() {
        return this.coreSession.getIdleTimeout().toMillis();
    }

    public void setIdleTimeout(long ms) {
        this.coreSession.setIdleTimeout(Duration.ofMillis(ms));
    }

    public void sendFrame(Frame frame, Callback callback, boolean batch) {
        this.sendFrame(new OutgoingEntry.Builder(frame, callback).batch(batch).messageTimeout(this.messageWriteTimeout).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendFrame(OutgoingEntry entry) {
        Frame frame = entry.getFrame();
        if (frame.isDataFrame()) {
            try {
                byte opcode = frame.getOpCode();
                if (this.messageType == -1) {
                    if (opcode != 2 && opcode != 1) throw new WebSocketException("Encountered invalid Data Frame opcode " + opcode);
                    this.messageType = opcode;
                } else {
                    if (this.messageType == 2 && opcode == 1) {
                        throw new WebSocketException("Cannot start TEXT message when BINARY message is not complete yet");
                    }
                    if (this.messageType == 1 && opcode == 2) {
                        throw new WebSocketException("Cannot start BINARY message when TEXT message is not complete yet");
                    }
                }
            }
            catch (Throwable t) {
                entry.getCallback().failed(t);
                return;
            }
        }
        try {
            this.coreSession.sendFrame(entry);
            return;
        }
        finally {
            if (frame.isFin()) {
                this.messageType = (byte)-1;
            }
        }
    }

    public void sendObject(Object data, Callback callback) throws IOException, EncodeException {
        try {
            Encoder encoder;
            this.assertMessageNotNull(data);
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendObject({}, {})", data, (Object)callback);
            }
            if ((encoder = this.session.getEncoders().getInstanceFor(data.getClass())) == null) {
                throw new IllegalArgumentException("No encoder for type: " + String.valueOf(data.getClass()));
            }
            if (encoder instanceof Encoder.Text) {
                Encoder.Text text = (Encoder.Text)encoder;
                String msg = text.encode(data);
                this.sendFrame(new Frame(1).setPayload(msg), callback, this.batch);
                return;
            }
            if (encoder instanceof Encoder.TextStream) {
                Encoder.TextStream etxt = (Encoder.TextStream)encoder;
                try (MessageWriter writer = this.newMessageWriter();){
                    writer.setCallback(callback);
                    etxt.encode(data, (Writer)writer);
                }
                return;
            }
            if (encoder instanceof Encoder.Binary) {
                Encoder.Binary ebin = (Encoder.Binary)encoder;
                ByteBuffer buf = ebin.encode(data);
                this.sendFrame(new Frame(2).setPayload(buf), callback, this.batch);
                return;
            }
            if (encoder instanceof Encoder.BinaryStream) {
                Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
                try (MessageOutputStream out = this.newMessageOutputStream();){
                    out.setCallback(callback);
                    ebin.encode(data, (OutputStream)out);
                }
                return;
            }
            throw new IllegalArgumentException("Unknown encoder type: " + String.valueOf(encoder));
        }
        catch (EncodeException | IOException | RuntimeException e) {
            callback.failed(e);
            throw e;
        }
        catch (Throwable t) {
            callback.failed(t);
            LOG.warn("Unable to send Object {}", data, (Object)t);
            return;
        }
    }

    public void sendPing(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing({})", (Object)BufferUtil.toDetailString((ByteBuffer)data));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(9).setPayload(data), (Callback)b, this.batch);
        b.block();
    }

    public void sendPong(ByteBuffer data) throws IOException, IllegalArgumentException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong({})", (Object)BufferUtil.toDetailString((ByteBuffer)data));
        }
        FutureCallback b = new FutureCallback();
        this.sendFrame(new Frame(10).setPayload(data), (Callback)b, this.batch);
        b.block();
    }

    protected void assertMessageNotNull(Object data) {
        if (data == null) {
            throw new IllegalArgumentException("message cannot be null");
        }
    }

    protected void assertSendHandlerNotNull(SendHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("SendHandler cannot be null");
        }
    }
}

