/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.projectmanagement;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.firebase.internal.Nullable;

public class AndroidAppMetadata {
    private final String name;
    private final String appId;
    private final String displayName;
    private final String projectId;
    private final String packageName;

    AndroidAppMetadata(String name, String appId, String displayName, String projectId, String packageName) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Null name");
        this.appId = (String)Preconditions.checkNotNull((Object)appId, (Object)"Null appId");
        this.displayName = displayName;
        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Null projectId");
        this.packageName = (String)Preconditions.checkNotNull((Object)packageName, (Object)"Null packageName");
    }

    String getName() {
        return this.name;
    }

    public String getAppId() {
        return this.appId;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AndroidAppMetadata").add("name", (Object)this.name).add("appId", (Object)this.appId).add("displayName", (Object)this.displayName).add("projectId", (Object)this.projectId).add("packageName", (Object)this.packageName).toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AndroidAppMetadata) {
            AndroidAppMetadata that = (AndroidAppMetadata)o;
            return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.appId, (Object)that.appId) && Objects.equal((Object)this.displayName, (Object)that.displayName) && Objects.equal((Object)this.projectId, (Object)that.projectId) && Objects.equal((Object)this.packageName, (Object)that.packageName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.appId, this.displayName, this.projectId, this.packageName});
    }
}

