/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.Objects;
import org.eclipse.aether.util.version.GenericVersion;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.Version;
import org.eclipse.aether.version.VersionRange;

final class GenericVersionRange
implements VersionRange {
    private final VersionRange.Bound lowerBound;
    private final VersionRange.Bound upperBound;

    GenericVersionRange(String range2) throws InvalidVersionSpecificationException {
        Version upperBound;
        Version lowerBound;
        boolean upperBoundInclusive;
        boolean lowerBoundInclusive;
        String process2 = range2;
        if (range2.startsWith("[")) {
            lowerBoundInclusive = true;
        } else if (range2.startsWith("(")) {
            lowerBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range2, "Invalid version range " + range2 + ", a range must start with either [ or (");
        }
        if (range2.endsWith("]")) {
            upperBoundInclusive = true;
        } else if (range2.endsWith(")")) {
            upperBoundInclusive = false;
        } else {
            throw new InvalidVersionSpecificationException(range2, "Invalid version range " + range2 + ", a range must end with either [ or (");
        }
        process2 = process2.substring(1, process2.length() - 1);
        int index2 = process2.indexOf(",");
        if (index2 < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new InvalidVersionSpecificationException(range2, "Invalid version range " + range2 + ", single version must be surrounded by []");
            }
            String version = process2.trim();
            if (version.endsWith(".*")) {
                String prefix = version.substring(0, version.length() - 1);
                lowerBound = this.parse(prefix + "min");
                upperBound = this.parse(prefix + "max");
            } else {
                upperBound = lowerBound = this.parse(version);
            }
        } else {
            String parsedLowerBound = process2.substring(0, index2).trim();
            String parsedUpperBound = process2.substring(index2 + 1).trim();
            if (parsedUpperBound.contains(",")) {
                throw new InvalidVersionSpecificationException(range2, "Invalid version range " + range2 + ", bounds may not contain additional ','");
            }
            lowerBound = parsedLowerBound.length() > 0 ? this.parse(parsedLowerBound) : null;
            Version version = upperBound = parsedUpperBound.length() > 0 ? this.parse(parsedUpperBound) : null;
            if (upperBound != null && lowerBound != null && upperBound.compareTo(lowerBound) < 0) {
                throw new InvalidVersionSpecificationException(range2, "Invalid version range " + range2 + ", lower bound must not be greater than upper bound");
            }
        }
        this.lowerBound = lowerBound != null ? new VersionRange.Bound(lowerBound, lowerBoundInclusive) : null;
        this.upperBound = upperBound != null ? new VersionRange.Bound(upperBound, upperBoundInclusive) : null;
    }

    private Version parse(String version) {
        return new GenericVersion(version);
    }

    @Override
    public VersionRange.Bound getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public VersionRange.Bound getUpperBound() {
        return this.upperBound;
    }

    @Override
    public boolean containsVersion(Version version) {
        int comparison;
        if (this.lowerBound != null) {
            comparison = this.lowerBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.lowerBound.isInclusive()) {
                return false;
            }
            if (comparison > 0) {
                return false;
            }
        }
        if (this.upperBound != null) {
            comparison = this.upperBound.getVersion().compareTo(version);
            if (comparison == 0 && !this.upperBound.isInclusive()) {
                return false;
            }
            if (comparison < 0) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        GenericVersionRange that = (GenericVersionRange)obj;
        return Objects.equals(this.upperBound, that.upperBound) && Objects.equals(this.lowerBound, that.lowerBound);
    }

    public int hashCode() {
        int hash2 = 17;
        hash2 = hash2 * 31 + GenericVersionRange.hash(this.upperBound);
        hash2 = hash2 * 31 + GenericVersionRange.hash(this.lowerBound);
        return hash2;
    }

    private static int hash(Object obj) {
        return obj != null ? obj.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buffer2 = new StringBuilder(64);
        if (this.lowerBound != null) {
            buffer2.append(this.lowerBound.isInclusive() ? (char)'[' : '(');
            buffer2.append(this.lowerBound.getVersion());
        } else {
            buffer2.append('(');
        }
        buffer2.append(',');
        if (this.upperBound != null) {
            buffer2.append(this.upperBound.getVersion());
            buffer2.append(this.upperBound.isInclusive() ? (char)']' : ')');
        } else {
            buffer2.append(')');
        }
        return buffer2.toString();
    }
}

