/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import net.sf.freecol.client.ClientOptions;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;

public final class MiniMap
extends JPanel
implements MouseInputListener {
    private static final Logger logger = Logger.getLogger(MiniMap.class.getName());
    public static final int MAX_TILE_SIZE = 24;
    public static final int MIN_TILE_SIZE = 4;
    public static final int SCALE_STEP = 4;
    private final FreeColClient freeColClient;
    private int tileSize;
    private int firstColumn;
    private int firstRow;
    private int adjustX = 0;
    private int adjustY = 0;

    public MiniMap(FreeColClient freeColClient) {
        this.freeColClient = freeColClient;
        this.setLayout(null);
        this.tileSize = 4 * freeColClient.getClientOptions().getInteger("model.option.defaultZoomLevel");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    private GUI getGUI() {
        return this.freeColClient.getGUI();
    }

    private Game getGame() {
        return this.freeColClient.getGame();
    }

    private Map getMap() {
        Game game = this.getGame();
        return game == null ? null : game.getMap();
    }

    private void setZoomOption(int tileSize) {
        int zoom = tileSize / 4;
        this.freeColClient.getClientOptions().setInteger("model.option.defaultZoomLevel", zoom);
    }

    private void setFocus(MouseEvent e) {
        if (!e.getComponent().isEnabled()) {
            return;
        }
        Map map = this.getMap();
        if (map == null) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int tileX = (x - this.adjustX) / this.tileSize + this.firstColumn;
        int tileY = (y - this.adjustY) / this.tileSize * 4 + this.firstRow;
        if (tileX >= map.getWidth()) {
            tileX = map.getWidth() - 1;
        }
        if (tileY >= map.getHeight()) {
            tileY = map.getHeight() - 1;
        }
        if (tileX < 0) {
            tileX = 0;
        }
        if (tileY < 0) {
            tileY = 0;
        }
        this.getGUI().setFocus(map.getTile(tileX, tileY));
    }

    public void zoomIn() {
        this.tileSize = Math.min(this.tileSize + 4, 24);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public void zoomOut() {
        this.tileSize = Math.max(this.tileSize - 4, 4);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public boolean canZoomIn() {
        return this.tileSize < 24 && this.getMap() != null;
    }

    public boolean canZoomOut() {
        return this.tileSize > 4 && this.getMap() != null;
    }

    public void setTileSize(int size) {
        this.tileSize = Math.max(Math.min(size, 24), 4);
        this.setZoomOption(this.tileSize);
        this.repaint();
    }

    public void paintMap(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        AffineTransform originTransform = g.getTransform();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        int minimapWidth = this.getWidth();
        int minimapHeight = this.getHeight();
        g.setColor(ImageLibrary.getMinimapBackgroundColor());
        g.fillRect(0, 0, minimapWidth, minimapHeight);
        Tile focus = this.getGUI().getFocus();
        if (focus == null) {
            return;
        }
        int xSize = minimapWidth / this.tileSize;
        int ySize = minimapHeight / this.tileSize * 4;
        this.firstColumn = focus.getX() - xSize / 2;
        this.firstRow = focus.getY() - ySize / 2;
        Map map = this.getMap();
        int mWidth = map.getWidth();
        int mHeight = map.getHeight();
        this.firstColumn = Math.max(0, Math.min(mWidth - xSize - 1, this.firstColumn));
        this.firstRow = Math.max(0, Math.min(mHeight - ySize - 1, this.firstRow));
        if (mWidth <= xSize) {
            this.firstColumn = 0;
            this.adjustX = (minimapWidth - mWidth * this.tileSize) / 2;
            minimapWidth = mWidth * this.tileSize;
        } else {
            this.adjustX = 0;
        }
        if (mHeight <= ySize) {
            this.firstRow = 0;
            this.adjustY = (minimapHeight - mHeight * (this.tileSize / 4)) / 2;
            minimapHeight = mHeight * (this.tileSize / 4);
        } else {
            this.adjustY = 0;
        }
        int lastRow = Math.min(this.firstRow + ySize, mHeight - 1);
        int lastColumn = Math.min(this.firstColumn + xSize, mWidth - 1);
        int tileWidth = this.tileSize;
        int tileHeight = this.tileSize / 2;
        int halfWidth = this.tileSize / 2;
        int halfHeight = this.tileSize / 4;
        GeneralPath tilePath = new GeneralPath();
        tilePath.moveTo(halfWidth, 0.0f);
        tilePath.lineTo(tileWidth, halfHeight);
        tilePath.lineTo(halfWidth, tileHeight);
        tilePath.lineTo(0.0f, halfHeight);
        tilePath.closePath();
        GeneralPath settlementPath = new GeneralPath(tilePath);
        settlementPath.transform(AffineTransform.getScaleInstance(0.7, 0.7));
        settlementPath.transform(AffineTransform.getTranslateInstance(0.15 * (double)tileWidth, 0.15 * (double)tileHeight));
        GeneralPath unitPath = new GeneralPath(tilePath);
        unitPath.transform(AffineTransform.getScaleInstance(0.5, 0.5));
        unitPath.transform(AffineTransform.getTranslateInstance(0.25 * (double)tileWidth, 0.25 * (double)tileHeight));
        GeneralPath paintFull = new GeneralPath(tilePath);
        paintFull.transform(AffineTransform.getScaleInstance(1.0, 1.0));
        g.setStroke(new BasicStroke(1.0f));
        g.translate(this.adjustX, this.adjustY);
        AffineTransform baseTransform = g.getTransform();
        AffineTransform rowTransform = null;
        ClientOptions clientOptions = this.freeColClient.getClientOptions();
        for (int row = this.firstRow; row <= lastRow; ++row) {
            rowTransform = g.getTransform();
            if ((row & 1) == 1) {
                g.translate(halfWidth, 0);
            }
            for (int column = this.firstColumn; column <= lastColumn; ++column) {
                Tile tile = map.getTile(column, row);
                if (tile.isExplored()) {
                    if (clientOptions.getBoolean("model.option.miniMapToggleBorders")) {
                        g.setColor(ImageLibrary.getMinimapPoliticsColor(tile.getType()));
                        g.fill(tilePath);
                        if (tile.getOwner() != null) {
                            Color nationOwner = tile.getOwner().getNationColor();
                            Color colorTransparent = new Color(nationOwner.getRed(), nationOwner.getGreen(), nationOwner.getBlue(), 100);
                            g.setColor(colorTransparent);
                            g.fill(paintFull);
                        }
                    } else {
                        g.setColor(ImageLibrary.getMinimapEconomicColor(tile.getType()));
                        g.fill(tilePath);
                    }
                    if (!tile.hasSettlement()) {
                        Unit unit = tile.getFirstUnit();
                        if (unit != null) {
                            g.setColor(Color.BLACK);
                            g.draw(unitPath);
                            g.setColor(unit.getOwner().getNationColor());
                            g.fill(unitPath);
                        }
                    } else {
                        g.setColor(Color.BLACK);
                        g.draw(settlementPath);
                        g.setColor(tile.getSettlement().getOwner().getNationColor());
                        g.fill(settlementPath);
                    }
                    if (!this.freeColClient.isMapEditor() && !this.freeColClient.getMyPlayer().canSee(tile) && clientOptions.getBoolean("model.option.miniMapToggleFogOfWar")) {
                        Color blackTransparent = new Color(0, 0, 0, 100);
                        g.setColor(blackTransparent);
                        g.fill(paintFull);
                    }
                }
                g.translate(tileWidth, 0);
            }
            g.setTransform(rowTransform);
            g.translate(0, halfHeight);
        }
        g.setTransform(baseTransform);
        this.paintActualMapWhiteRectangle(g, minimapWidth, minimapHeight);
        g.setTransform(originTransform);
    }

    private void paintActualMapWhiteRectangle(Graphics2D g, int minimapWidth, int minimapHeight) {
        Dimension actualMapViewDimension = this.getGUI().getMapViewDimension();
        if (actualMapViewDimension == null) {
            return;
        }
        int miniRectX = (this.getGUI().getFocus().getX() - this.firstColumn) * this.tileSize;
        int miniRectY = (this.getGUI().getFocus().getY() - this.firstRow) * this.tileSize / 4;
        Dimension mapTileSize = this.getGUI().getScaledImageLibrary().scale(ImageLibrary.TILE_SIZE);
        int miniRectWidth = (actualMapViewDimension.width / mapTileSize.width + 1) * this.tileSize;
        int miniRectHeight = (actualMapViewDimension.height / mapTileSize.height + 1) * this.tileSize / 2;
        if (miniRectX + miniRectWidth / 2 > minimapWidth) {
            miniRectX = minimapWidth - miniRectWidth / 2 - 1;
        } else if (miniRectX - miniRectWidth / 2 < 0) {
            miniRectX = miniRectWidth / 2;
        }
        if (miniRectY + miniRectHeight / 2 > minimapHeight) {
            miniRectY = minimapHeight - miniRectHeight / 2 - 1;
        } else if (miniRectY - miniRectHeight / 2 < 0) {
            miniRectY = miniRectHeight / 2;
        }
        g.setColor(ImageLibrary.getMinimapBorderColor());
        int miniRectMaxX = Math.max(miniRectX - miniRectWidth / 2, 0);
        int miniRectMaxY = Math.max(miniRectY - miniRectHeight / 2, 0);
        int miniRectMinWidth = Math.min(miniRectWidth, minimapWidth - 1);
        int miniRectMinHeight = Math.min(miniRectHeight, minimapHeight - 1);
        if (miniRectMaxX + miniRectMinWidth > minimapWidth - 1) {
            miniRectMaxX = minimapWidth - miniRectMinWidth - 1;
        }
        if (miniRectMaxY + miniRectMinHeight > minimapHeight - 1) {
            miniRectMaxY = minimapHeight - miniRectMinHeight - 1;
        }
        g.drawRect(miniRectMaxX, miniRectMaxY, miniRectMinWidth, miniRectMinHeight);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.setFocus(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.setFocus(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.getMap() == null) {
            return;
        }
        graphics.drawImage(ImageLibrary.getMiniMapBackground(), 0, 0, null);
        this.paintMap(graphics);
    }
}

