/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@TypeQualifier(applicableTo=Number.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Nonnegative {
    public When when() default When.ALWAYS;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Checker
    implements TypeQualifierValidator<Nonnegative> {
        @Override
        public When forConstantValue(Nonnegative annotation, Object v) {
            boolean isNegative;
            if (!(v instanceof Number)) {
                return When.NEVER;
            }
            Number value2 = (Number)v;
            if (value2 instanceof Long) {
                isNegative = value2.longValue() < 0L;
            } else if (value2 instanceof Double) {
                isNegative = value2.doubleValue() < 0.0;
            } else if (value2 instanceof Float) {
                isNegative = value2.floatValue() < 0.0f;
            } else {
                boolean bl = isNegative = value2.intValue() < 0;
            }
            if (isNegative) {
                return When.NEVER;
            }
            return When.ALWAYS;
        }
    }
}

