/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import org.hibernate.AssertionFailure;
import org.hibernate.id.enhanced.CustomOptimizerDescriptor;
import org.hibernate.id.enhanced.HiLoOptimizer;
import org.hibernate.id.enhanced.LegacyHiLoAlgorithmOptimizer;
import org.hibernate.id.enhanced.NoopOptimizer;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerDescriptor;
import org.hibernate.id.enhanced.PooledLoOptimizer;
import org.hibernate.id.enhanced.PooledLoThreadLocalOptimizer;
import org.hibernate.id.enhanced.PooledOptimizer;
import org.hibernate.internal.util.StringHelper;

public enum StandardOptimizerDescriptor implements OptimizerDescriptor
{
    NONE,
    HILO,
    LEGACY_HILO,
    POOLED,
    POOLED_LO,
    POOLED_LOTL;


    @Override
    public String getExternalName() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case HILO: {
                return "hilo";
            }
            case LEGACY_HILO: {
                return "legacy-hilo";
            }
            case POOLED: {
                return "pooled";
            }
            case POOLED_LO: {
                return "pooled-lo";
            }
            case POOLED_LOTL: {
                return "pooled-lotl";
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    @Override
    public Class<? extends Optimizer> getOptimizerClass() {
        switch (this) {
            case NONE: {
                return NoopOptimizer.class;
            }
            case HILO: {
                return HiLoOptimizer.class;
            }
            case LEGACY_HILO: {
                return LegacyHiLoAlgorithmOptimizer.class;
            }
            case POOLED: {
                return PooledOptimizer.class;
            }
            case POOLED_LO: {
                return PooledLoOptimizer.class;
            }
            case POOLED_LOTL: {
                return PooledLoThreadLocalOptimizer.class;
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    @Override
    public boolean isPooled() {
        switch (this) {
            case NONE: 
            case HILO: 
            case LEGACY_HILO: {
                return false;
            }
            case POOLED: 
            case POOLED_LO: 
            case POOLED_LOTL: {
                return true;
            }
        }
        throw new AssertionFailure("unknown StandardOptimizerDescriptor");
    }

    public static OptimizerDescriptor fromExternalName(String externalName) {
        if (StringHelper.isEmpty(externalName)) {
            return NONE;
        }
        for (StandardOptimizerDescriptor value : StandardOptimizerDescriptor.values()) {
            if (!value.getExternalName().equals(externalName)) continue;
            return value;
        }
        return new CustomOptimizerDescriptor(externalName);
    }
}

