/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventListJXTableSorting;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.publicobject.issuesbrowser.Issue;
import com.publicobject.issuesbrowser.IssueTableFormat;
import com.publicobject.issuesbrowser.IssueTextFilterator;
import com.publicobject.issuesbrowser.IssuezillaXMLParser;
import com.publicobject.issuesbrowser.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JXTableTest
implements Runnable {
    private EventList<Issue> issues;

    public JXTableTest(EventList<Issue> issues) {
        this.issues = issues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.issues.getReadWriteLock().writeLock().lock();
        try {
            JTextField filterEdit = new JTextField(12);
            TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor(filterEdit, new IssueTextFilterator());
            FilterList<Issue> textFilteredIssues = new FilterList<Issue>(this.issues, textMatcherEditor);
            SortedList<Issue> sortedIssues = new SortedList<Issue>(textFilteredIssues, null);
            EventTableModel<Issue> tableModel = new EventTableModel<Issue>((EventList<Issue>)sortedIssues, (TableFormat<Issue>)new IssueTableFormat());
            JPanel filterPanel = new JPanel(new FlowLayout(0));
            filterPanel.add(new JLabel("Filter:"));
            filterPanel.add(filterEdit);
            JXTable table = new JXTable(tableModel);
            table.setColumnControlVisible(true);
            table.getColumnExt(3).setComparator((Comparator)new IssueStateComparator());
            EventListJXTableSorting.install(table, sortedIssues);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)filterPanel, "North");
            frame.getContentPane().add((Component)new JScrollPane((Component)table), "Center");
            frame.pack();
            frame.setVisible(true);
        }
        finally {
            this.issues.getReadWriteLock().writeLock().unlock();
        }
    }

    public static void main(String[] args) {
        BasicEventList<Issue> issues = new BasicEventList<Issue>();
        new Thread(new IssueLoader(issues, args[0])).start();
        SwingUtilities.invokeLater(new JXTableTest(issues));
    }

    private static class IssueStateComparator
    implements Comparator {
        private static final List STATES = Arrays.asList("UNCONFIRMED", "NEW", "STARTED", "REOPENED", "RESOLVED", "VERIFIED", "CLOSED");

        private IssueStateComparator() {
        }

        public int compare(Object a, Object b) {
            int stateIndexA = STATES.indexOf(a);
            int stateIndexB = STATES.indexOf(b);
            if (stateIndexA == -1 || stateIndexB == -1) {
                throw new IllegalStateException();
            }
            return stateIndexA - stateIndexB;
        }
    }

    private static class IssueLoader
    implements Runnable {
        private EventList issues;
        private Project project;

        public IssueLoader(EventList issues, String filename) {
            this.issues = issues;
            this.project = new Project("Glazed Lists", "Glazed Lists");
            this.project.setFileName(filename);
        }

        public void run() {
            try {
                IssuezillaXMLParser.loadIssues(GlazedLists.threadSafeList(this.issues), (InputStream)new FileInputStream(this.project.getFileName()), (Project)this.project);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }
}

