#!/usr/local/bin/python3

import sqlite3
import json
import re

def main():
    database = r"/usr/local/share/sqlports"

    conn = sqlite3.connect(database)
    data = []
    pkgs = dict()
    with conn:
        cursor = conn.execute("SELECT FULLPKGNAME, COMMENT, DESCR_CONTENTS, WANTLIB, RUN_DEPENDS FROM PortsQ")
        for row in cursor:
            if not pkgs.get(row[0]):
                pkgs[row[0]] = True
                gui = False
                tui = False
                if row[3]:
                    m = re.search("(GL|SDL|gtk-3|X11|Qt5Gui)", row[3])
                    if m:
                        gui = True
                    m = re.search("(curses)", row[3])
                    if m:
                        tui = True
                if row[4]:
                    m = re.search("x11/gtk\+3,-guic", row[4])
                    if m:
                        gui = True
                if not gui and row[2] and row[3] and row[1] and not tui:
                    m = re.search("(client)", row[3]+row[1]+row[2])
                    if m:
                        tui = True
                data.append({
                  "pkgname": row[0], #"-".join(row[0].split("-")[:-1]),
                  "comment": row[1],
                  "descr": row[2],
                  "gui": gui,
                  "tui": tui
                  })
    print(json.dumps(data))

main()
