/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.olap.OLAPContextMenuFactory;
import ca.sqlpower.architect.swingui.olap.OLAPEditSession;
import ca.sqlpower.architect.swingui.olap.OLAPTreeModel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.JTreeCollapseAllAction;
import ca.sqlpower.swingui.JTreeExpandAllAction;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class OLAPTree
extends JTree {
    private static final Logger logger = Logger.getLogger(OLAPTree.class);
    private final OLAPContextMenuFactory menuFactory;
    private final JTreeCollapseAllAction collapseAllAction;
    private final JTreeExpandAllAction expandAllAction;
    private MondrianModel.Schema schema;

    public OLAPTree(ArchitectSwingSession session, OLAPEditSession oSession, MondrianModel.Schema schema) {
        this.schema = schema;
        this.setModel(new OLAPTreeModel(schema));
        this.addMouseListener(new PopupListener());
        this.collapseAllAction = new JTreeCollapseAllAction((JTree)this, "Collapse All");
        this.expandAllAction = new JTreeExpandAllAction((JTree)this, "Expand All");
        this.menuFactory = new OLAPContextMenuFactory(session, oSession);
    }

    public TreePath getTreePathForNode(SPObject o) {
        ArrayList<SPObject> path = new ArrayList<SPObject>();
        while (o != null) {
            path.add(0, o);
            if (o == this.schema) break;
            o = o.getParent();
        }
        return new TreePath(path.toArray());
    }

    public void clearNonPlayPenSelections() {
        if (this.getSelectionPaths() == null) {
            return;
        }
        for (TreePath tp : this.getSelectionPaths()) {
            OLAPObject obj = (OLAPObject)((Object)tp.getLastPathComponent());
            if (obj instanceof MondrianModel.Cube || obj instanceof MondrianModel.VirtualCube || obj instanceof MondrianModel.Measure || obj instanceof MondrianModel.CubeDimension || obj instanceof MondrianModel.VirtualCubeMeasure || obj instanceof MondrianModel.Level || obj instanceof MondrianModel.Hierarchy || obj instanceof MondrianModel.CubeUsage) continue;
            this.removeSelectionPath(tp);
        }
    }

    protected boolean isSchemaNode(TreePath tp) {
        if (tp == null) {
            return false;
        }
        return this.schema == tp.getLastPathComponent();
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e, true);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e, false);
        }

        private void maybeShowPopup(MouseEvent e, boolean isPress) {
            TreePath p = OLAPTree.this.getPathForLocation(e.getX(), e.getY());
            if (e.isPopupTrigger()) {
                logger.debug((Object)("TreePath is: " + p));
                if (!OLAPTree.this.isPathSelected(p)) {
                    OLAPTree.this.setSelectionPath(p);
                }
                OLAPObject lpc = null;
                if (p != null) {
                    logger.debug((Object)("selected node object type is: " + p.getLastPathComponent().getClass().getName()));
                    lpc = (OLAPObject)((Object)p.getLastPathComponent());
                }
                JPopupMenu popup = OLAPTree.this.menuFactory.createPopupMenu((Object)lpc);
                if (lpc != null) {
                    popup.addSeparator();
                    popup.add((Action)OLAPTree.this.collapseAllAction);
                    popup.add((Action)OLAPTree.this.expandAllAction);
                }
                popup.show(e.getComponent(), e.getX(), e.getY());
            } else if (p == null && !isPress && e.getButton() == 1) {
                OLAPTree.this.setSelectionPath(null);
            }
        }
    }
}

