untrusted comment: signature from openbsd 6.0 base secret key
RWSho3oKSqgLQ/PABGAAj4tgJm8RG0U2uH4SUOLh2b3YBXPRVkCb9GC+SW3GVZWBWjtPU3Eus+/+baddglO+AwJuMPPuIyG9oAE=

OpenBSD 6.0 errata 21, May 1, 2017:

softraid(4) was unable to create usable concat volumes because
it always set the size of the volume to zero sectors.

Apply by doing:
    signify -Vep /etc/signify/openbsd-60-base.pub -x 021_softraid_concat.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install a new kernel:
    cd /usr/src/sys/arch/`machine`/conf
    KK=`sysctl -n kern.osversion | cut -d# -f1`
    config $KK
    cd ../compile/$KK
    make
    make install

Index: sys/dev/softraid_concat.c
===================================================================
RCS file: /cvs/src/sys/dev/softraid_concat.c,v
--- sys/dev/softraid_concat.c	12 Apr 2016 16:26:54 -0000	1.25
+++ sys/dev/softraid_concat.c	28 Apr 2017 23:33:07 -0000	1.26
@@ -60,11 +60,19 @@ int
 sr_concat_create(struct sr_discipline *sd, struct bioc_createraid *bc,
     int no_chunk, int64_t coerced_size)
 {
+	int i;
+
 	if (no_chunk < 2) {
 		sr_error(sd->sd_sc, "%s requires two or more chunks",
 		    sd->sd_name);
 		return EINVAL;
         }
+	
+	sd->sd_meta->ssdi.ssd_size = 0;
+	for (i = 0; i < no_chunk; i++) {
+		sd->sd_meta->ssdi.ssd_size +=
+		    sd->sd_vol.sv_chunks[i]->src_size;
+	}
 
 	return sr_concat_init(sd);
 }

