/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ifnull;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.ifnull.IfNull;
import org.pentaho.di.trans.steps.ifnull.IfNullData;
import org.pentaho.di.trans.steps.ifnull.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfNullMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String[] fieldName;
    private String[] replaceValue;
    private String[] typeName;
    private String[] typereplaceValue;
    private String[] typereplaceMask;
    private String[] replaceMask;
    private boolean selectFields;
    private boolean selectValuesType;
    private String replaceAllByValue;
    private String replaceAllMask;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        int i;
        IfNullMeta retval = (IfNullMeta)super.clone();
        int nrTypes = this.typeName.length;
        int nrfields = this.fieldName.length;
        retval.allocate(nrTypes, nrfields);
        for (i = 0; i < nrTypes; ++i) {
            retval.typeName[i] = this.typeName[i];
            retval.typereplaceValue[i] = this.typereplaceValue[i];
            retval.typereplaceMask[i] = this.typereplaceMask[i];
        }
        for (i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.replaceValue[i] = this.replaceValue[i];
            retval.replaceMask[i] = this.replaceMask[i];
        }
        return retval;
    }

    public void allocate(int nrtypes, int nrfields) {
        this.typeName = new String[nrtypes];
        this.typereplaceValue = new String[nrtypes];
        this.typereplaceMask = new String[nrtypes];
        this.fieldName = new String[nrfields];
        this.replaceValue = new String[nrfields];
        this.replaceMask = new String[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String[] typeName) {
        this.typeName = typeName;
    }

    public String[] getReplaceValue() {
        return this.replaceValue;
    }

    public void setReplaceValue(String[] replaceValue) {
        this.replaceValue = replaceValue;
    }

    public String[] getTypeReplaceValue() {
        return this.typereplaceValue;
    }

    public String[] getTypeReplaceMask() {
        return this.typereplaceMask;
    }

    public String[] getReplaceMask() {
        return this.replaceMask;
    }

    public void setTypeReplaceMask(String[] typereplaceMask) {
        this.typereplaceMask = typereplaceMask;
    }

    public void setReplaceMask(String[] replaceMask) {
        this.replaceMask = replaceMask;
    }

    public void setTypeReplaceValue(String[] typereplaceValue) {
        this.typereplaceValue = typereplaceValue;
    }

    public boolean isSelectFields() {
        return this.selectFields;
    }

    public void setSelectFields(boolean selectFields) {
        this.selectFields = selectFields;
    }

    public void setSelectValuesType(boolean selectValuesType) {
        this.selectValuesType = selectValuesType;
    }

    public boolean isSelectValuesType() {
        return this.selectValuesType;
    }

    public void setReplaceAllByValue(String replaceValue) {
        this.replaceAllByValue = replaceValue;
    }

    public String getReplaceAllByValue() {
        return this.replaceAllByValue;
    }

    public void setReplaceAllMask(String replaceAllMask) {
        this.replaceAllMask = replaceAllMask;
    }

    public String getReplaceAllMask() {
        return this.replaceAllMask;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            int i;
            this.selectFields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"selectFields"));
            this.selectValuesType = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"selectValuesType"));
            this.replaceAllByValue = XMLHandler.getTagValue((Node)stepnode, (String)"replaceAllByValue");
            this.replaceAllMask = XMLHandler.getTagValue((Node)stepnode, (String)"replaceAllMask");
            Node types = XMLHandler.getSubNode((Node)stepnode, (String)"valuetypes");
            int nrtypes = XMLHandler.countNodes((Node)types, (String)"valuetype");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrtypes, nrfields);
            for (i = 0; i < nrtypes; ++i) {
                Node tnode = XMLHandler.getSubNodeByNr((Node)types, (String)"valuetype", (int)i);
                this.typeName[i] = XMLHandler.getTagValue((Node)tnode, (String)"name");
                this.typereplaceValue[i] = XMLHandler.getTagValue((Node)tnode, (String)"value");
                this.typereplaceMask[i] = XMLHandler.getTagValue((Node)tnode, (String)"mask");
            }
            for (i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.replaceValue[i] = XMLHandler.getTagValue((Node)fnode, (String)"value");
                this.replaceMask[i] = XMLHandler.getTagValue((Node)fnode, (String)"mask");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("It was not possibke to load the IfNull metadata from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("      " + XMLHandler.addTagValue((String)"replaceAllByValue", (String)this.replaceAllByValue));
        retval.append("      " + XMLHandler.addTagValue((String)"replaceAllMask", (String)this.replaceAllMask));
        retval.append("      " + XMLHandler.addTagValue((String)"selectFields", (boolean)this.selectFields));
        retval.append("      " + XMLHandler.addTagValue((String)"selectValuesType", (boolean)this.selectValuesType));
        retval.append("    <valuetypes>" + Const.CR);
        for (i = 0; i < this.typeName.length; ++i) {
            retval.append("      <valuetype>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.typeName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.typereplaceValue[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)this.typereplaceMask[i]));
            retval.append("        </valuetype>" + Const.CR);
        }
        retval.append("      </valuetypes>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"value", (String)this.replaceValue[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"mask", (String)this.replaceMask[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        int i;
        this.replaceAllByValue = null;
        this.replaceAllMask = null;
        this.selectFields = false;
        this.selectValuesType = false;
        int nrfields = 0;
        int nrtypes = 0;
        this.allocate(nrtypes, nrfields);
        for (i = 0; i < nrtypes; ++i) {
            this.typeName[i] = "typename" + i;
            this.typereplaceValue[i] = "typevalue" + i;
            this.typereplaceMask[i] = "typemask" + i;
        }
        for (i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.replaceValue[i] = "value" + i;
            this.replaceMask[i] = "mask" + i;
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.replaceAllByValue = rep.getStepAttributeString(id_step, "replaceAllByValue");
            this.replaceAllMask = rep.getStepAttributeString(id_step, "replaceAllMask");
            this.selectFields = rep.getStepAttributeBoolean(id_step, "selectFields");
            this.selectValuesType = rep.getStepAttributeBoolean(id_step, "selectValuesType");
            int nrtypes = rep.countNrStepAttributes(id_step, "type_name");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrtypes, nrfields);
            for (i = 0; i < nrtypes; ++i) {
                this.typeName[i] = rep.getStepAttributeString(id_step, i, "type_name");
                this.typereplaceValue[i] = rep.getStepAttributeString(id_step, i, "type_replace_value");
                this.typereplaceMask[i] = rep.getStepAttributeString(id_step, i, "type_replace_mask");
            }
            for (i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.replaceValue[i] = rep.getStepAttributeString(id_step, i, "replace_value");
                this.replaceMask[i] = rep.getStepAttributeString(id_step, i, "replace_mask");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "replaceAllByValue", this.replaceAllByValue);
            rep.saveStepAttribute(id_transformation, id_step, "replaceAllMask", this.replaceAllMask);
            rep.saveStepAttribute(id_transformation, id_step, "selectFields", this.selectFields);
            rep.saveStepAttribute(id_transformation, id_step, "selectValuesType", this.selectValuesType);
            for (i = 0; i < this.typeName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "type_name", this.typeName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "type_replace_value", this.typereplaceValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "type_replace_mask", this.typereplaceMask[i]);
            }
            for (i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "replace_value", this.replaceValue[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "replace_mask", this.replaceMask[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, Messages.getString("IfNullMeta.CheckResult.NotReceivingFields"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, Messages.getString("IfNullMeta.CheckResult.StepRecevingData", prev.size() + ""), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = Messages.getString("IfNullMeta.CheckResult.FieldsFound", error_message);
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, Messages.getString("IfNullMeta.CheckResult.AllFieldsFound"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, Messages.getString("IfNullMeta.CheckResult.NoFieldsEntered"), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("IfNullMeta.CheckResult.StepRecevingData2"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("IfNullMeta.CheckResult.NoInputReceivedFromOtherSteps"), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new IfNull(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new IfNullData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

