/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.DigestMD5Base;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;

final class DigestMD5Server
extends DigestMD5Base
implements SaslServer {
    private static final String MY_CLASS_NAME = DigestMD5Server.class.getName();
    private static final String UTF8_DIRECTIVE = "charset=utf-8,";
    private static final String ALGORITHM_DIRECTIVE = "algorithm=md5-sess";
    private static final int NONCE_COUNT_VALUE = 1;
    private static final String UTF8_PROPERTY = "com.sun.security.sasl.digest.utf8";
    private static final String REALM_PROPERTY = "com.sun.security.sasl.digest.realm";
    private static final String[] DIRECTIVE_KEY = new String[]{"username", "realm", "nonce", "cnonce", "nonce-count", "qop", "digest-uri", "response", "maxbuf", "charset", "cipher", "authzid", "auth-param"};
    private static final int USERNAME = 0;
    private static final int REALM = 1;
    private static final int NONCE = 2;
    private static final int CNONCE = 3;
    private static final int NONCE_COUNT = 4;
    private static final int QOP = 5;
    private static final int DIGEST_URI = 6;
    private static final int RESPONSE = 7;
    private static final int MAXBUF = 8;
    private static final int CHARSET = 9;
    private static final int CIPHER = 10;
    private static final int AUTHZID = 11;
    private static final int AUTH_PARAM = 12;
    private String specifiedQops;
    private byte[] myCiphers;
    private List<String> serverRealms = new ArrayList<String>();

    DigestMD5Server(String string, String string2, Map<String, ?> map, CallbackHandler callbackHandler) throws SaslException {
        super(map, MY_CLASS_NAME, 1, string + "/" + (string2 == null ? "*" : string2), callbackHandler);
        this.useUTF8 = true;
        if (map != null) {
            String string3;
            this.specifiedQops = (String)map.get("javax.security.sasl.qop");
            if ("false".equals((String)map.get(UTF8_PROPERTY))) {
                this.useUTF8 = false;
                logger.log(Level.FINE, "DIGEST80:Server supports ISO-Latin-1");
            }
            if ((string3 = (String)map.get(REALM_PROPERTY)) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ", \t\n");
                int n = stringTokenizer.countTokens();
                String string4 = null;
                for (int i = 0; i < n; ++i) {
                    string4 = stringTokenizer.nextToken();
                    logger.log(Level.FINE, "DIGEST81:Server supports realm {0}", string4);
                    this.serverRealms.add(string4);
                }
            }
        }
        String string5 = this.encoding = this.useUTF8 ? "UTF8" : "8859_1";
        if (this.serverRealms.isEmpty()) {
            if (string2 == null) {
                throw new SaslException("A realm must be provided in props or serverName");
            }
            this.serverRealms.add(string2);
        }
    }

    @Override
    public byte[] evaluateResponse(byte[] byArray) throws SaslException {
        if (byArray.length > 4096) {
            throw new SaslException("DIGEST-MD5: Invalid digest response length. Got:  " + byArray.length + " Expected < " + 4096);
        }
        switch (this.step) {
            case 1: {
                if (byArray.length != 0) {
                    throw new SaslException("DIGEST-MD5 must not have an initial response");
                }
                String string = null;
                if ((this.allQop & 4) != 0) {
                    this.myCiphers = DigestMD5Server.getPlatformCiphers();
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < CIPHER_TOKENS.length; ++i) {
                        if (this.myCiphers[i] == 0) continue;
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(CIPHER_TOKENS[i]);
                    }
                    string = stringBuffer.toString();
                }
                try {
                    byte[] byArray2 = this.generateChallenge(this.serverRealms, this.specifiedQops, string);
                    this.step = 3;
                    return byArray2;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SaslException("DIGEST-MD5: Error encoding challenge", unsupportedEncodingException);
                }
                catch (IOException iOException) {
                    throw new SaslException("DIGEST-MD5: Error generating challenge", iOException);
                }
            }
            case 3: {
                byte[] byArray3;
                try {
                    byte[][] byArray4 = DigestMD5Server.parseDirectives(byArray, DIRECTIVE_KEY, null, 1);
                    byArray3 = this.validateClientResponse(byArray4);
                }
                catch (SaslException saslException) {
                    throw saslException;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new SaslException("DIGEST-MD5: Error validating client response", unsupportedEncodingException);
                }
                finally {
                    this.step = 0;
                }
                this.completed = true;
                if (this.integrity && this.privacy) {
                    this.secCtx = new DigestMD5Base.DigestPrivacy(false);
                } else if (this.integrity) {
                    this.secCtx = new DigestMD5Base.DigestIntegrity(false);
                }
                return byArray3;
            }
        }
        throw new SaslException("DIGEST-MD5: Server at illegal state");
    }

    private byte[] generateChallenge(List<String> list, String string, String string2) throws UnsupportedEncodingException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; list != null && i < list.size(); ++i) {
            byteArrayOutputStream.write("realm=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(byteArrayOutputStream, list.get(i).getBytes(this.encoding));
            byteArrayOutputStream.write(34);
            byteArrayOutputStream.write(44);
        }
        byteArrayOutputStream.write("nonce=\"".getBytes(this.encoding));
        this.nonce = DigestMD5Server.generateNonce();
        DigestMD5Server.writeQuotedStringValue(byteArrayOutputStream, this.nonce);
        byteArrayOutputStream.write(34);
        byteArrayOutputStream.write(44);
        if (string != null) {
            byteArrayOutputStream.write("qop=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(byteArrayOutputStream, string.getBytes(this.encoding));
            byteArrayOutputStream.write(34);
            byteArrayOutputStream.write(44);
        }
        if (this.recvMaxBufSize != 65536) {
            byteArrayOutputStream.write(("maxbuf=\"" + this.recvMaxBufSize + "\",").getBytes(this.encoding));
        }
        if (this.useUTF8) {
            byteArrayOutputStream.write(UTF8_DIRECTIVE.getBytes(this.encoding));
        }
        if (string2 != null) {
            byteArrayOutputStream.write("cipher=\"".getBytes(this.encoding));
            DigestMD5Server.writeQuotedStringValue(byteArrayOutputStream, string2.getBytes(this.encoding));
            byteArrayOutputStream.write(34);
            byteArrayOutputStream.write(44);
        }
        byteArrayOutputStream.write(ALGORITHM_DIRECTIVE.getBytes(this.encoding));
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] validateClientResponse(byte[][] byArray) throws SaslException, UnsupportedEncodingException {
        char[] cArray;
        Object object;
        Object object2;
        String string;
        int n;
        if (!(byArray[9] == null || this.useUTF8 && "utf-8".equals(new String(byArray[9], this.encoding)))) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Incompatible charset value: " + new String(byArray[9]));
        }
        int n2 = byArray[8] == null ? 65536 : Integer.parseInt(new String(byArray[8], this.encoding));
        int n3 = this.sendMaxBufSize = this.sendMaxBufSize == 0 ? n2 : Math.min(this.sendMaxBufSize, n2);
        if (byArray[0] == null) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Missing username.");
        }
        String string2 = new String(byArray[0], this.encoding);
        logger.log(Level.FINE, "DIGEST82:Username: {0}", string2);
        this.negotiatedRealm = byArray[1] != null ? new String(byArray[1], this.encoding) : "";
        logger.log(Level.FINE, "DIGEST83:Client negotiated realm: {0}", this.negotiatedRealm);
        if (!this.serverRealms.contains(this.negotiatedRealm)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Nonexistent realm: " + this.negotiatedRealm);
        }
        if (byArray[2] == null) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Missing nonce.");
        }
        byte[] byArray2 = byArray[2];
        if (!Arrays.equals(byArray2, this.nonce)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched nonce.");
        }
        if (byArray[3] == null) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Missing cnonce.");
        }
        byte[] byArray3 = byArray[3];
        if (byArray[4] != null && 1 != Integer.parseInt(new String(byArray[4], this.encoding), 16)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Nonce count does not match: " + new String(byArray[4]));
        }
        this.negotiatedQop = byArray[5] != null ? new String(byArray[5], this.encoding) : "auth";
        logger.log(Level.FINE, "DIGEST84:Client negotiated qop: {0}", this.negotiatedQop);
        String string3 = this.negotiatedQop;
        int n4 = -1;
        switch (string3.hashCode()) {
            case 3005864: {
                if (!string3.equals("auth")) break;
                n4 = 0;
                break;
            }
            case 1431098954: {
                if (!string3.equals("auth-int")) break;
                n4 = 1;
                break;
            }
            case 1414216745: {
                if (!string3.equals("auth-conf")) break;
                n4 = 2;
            }
        }
        switch (n4) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                this.integrity = true;
                this.rawSendSize = this.sendMaxBufSize - 16;
                break;
            }
            case 2: {
                n = 4;
                this.privacy = true;
                this.integrity = true;
                this.rawSendSize = this.sendMaxBufSize - 26;
                break;
            }
            default: {
                throw new SaslException("DIGEST-MD5: digest response format violation. Invalid QOP: " + this.negotiatedQop);
            }
        }
        if ((n & this.allQop) == 0) {
            throw new SaslException("DIGEST-MD5: server does not support  qop: " + this.negotiatedQop);
        }
        if (this.privacy) {
            String string4 = this.negotiatedCipher = byArray[10] != null ? new String(byArray[10], this.encoding) : null;
            if (this.negotiatedCipher == null) {
                throw new SaslException("DIGEST-MD5: digest response format violation. No cipher specified.");
            }
            int n5 = -1;
            logger.log(Level.FINE, "DIGEST85:Client negotiated cipher: {0}", this.negotiatedCipher);
            for (n4 = 0; n4 < CIPHER_TOKENS.length; ++n4) {
                if (!this.negotiatedCipher.equals(CIPHER_TOKENS[n4]) || this.myCiphers[n4] == 0) continue;
                n5 = n4;
                break;
            }
            if (n5 == -1) {
                throw new SaslException("DIGEST-MD5: server does not support cipher: " + this.negotiatedCipher);
            }
            this.negotiatedStrength = (CIPHER_MASKS[n5] & 4) != 0 ? "high" : ((CIPHER_MASKS[n5] & 2) != 0 ? "medium" : "low");
            logger.log(Level.FINE, "DIGEST86:Negotiated strength: {0}", this.negotiatedStrength);
        }
        String string5 = string3 = byArray[6] != null ? new String(byArray[6], this.encoding) : null;
        if (string3 != null) {
            logger.log(Level.FINE, "DIGEST87:digest URI: {0}", string3);
        }
        if (!DigestMD5Server.uriMatches(this.digestUri, string3)) {
            throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched URI: " + string3 + "; expecting: " + this.digestUri);
        }
        this.digestUri = string3;
        byte[] byArray4 = byArray[7];
        if (byArray4 == null) {
            throw new SaslException("DIGEST-MD5: digest response format  violation. Missing response.");
        }
        byte[] byArray5 = byArray[11];
        String string6 = string = byArray5 != null ? new String(byArray5, this.encoding) : string2;
        if (byArray5 != null) {
            logger.log(Level.FINE, "DIGEST88:Authzid: {0}", new String(byArray5));
        }
        try {
            object2 = new RealmCallback("DIGEST-MD5 realm: ", this.negotiatedRealm);
            object = new NameCallback("DIGEST-MD5 authentication ID: ", string2);
            PasswordCallback passwordCallback = new PasswordCallback("DIGEST-MD5 password: ", false);
            this.cbh.handle(new Callback[]{object2, object, passwordCallback});
            cArray = passwordCallback.getPassword();
            passwordCallback.clearPassword();
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new SaslException("DIGEST-MD5: Cannot perform callback to acquire password", unsupportedCallbackException);
        }
        catch (IOException iOException) {
            throw new SaslException("DIGEST-MD5: IO error acquiring password", iOException);
        }
        if (cArray == null) {
            throw new SaslException("DIGEST-MD5: cannot acquire password for " + string2 + " in realm : " + this.negotiatedRealm);
        }
        try {
            try {
                object2 = this.generateResponseValue("AUTHENTICATE", this.digestUri, this.negotiatedQop, string2, this.negotiatedRealm, cArray, this.nonce, byArray3, 1, byArray5);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: problem duplicating client response", noSuchAlgorithmException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: problem duplicating client response", iOException);
            }
            if (!Arrays.equals(byArray4, (byte[])object2)) {
                throw new SaslException("DIGEST-MD5: digest response format violation. Mismatched response.");
            }
            try {
                object = new AuthorizeCallback(string2, string);
                this.cbh.handle(new Callback[]{object});
                if (!((AuthorizeCallback)object).isAuthorized()) {
                    throw new SaslException("DIGEST-MD5: " + string2 + " is not authorized to act as " + string);
                }
                this.authzid = ((AuthorizeCallback)object).getAuthorizedID();
            }
            catch (SaslException saslException) {
                throw saslException;
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new SaslException("DIGEST-MD5: Cannot perform callback to check authzid", unsupportedCallbackException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: IO error checking authzid", iOException);
            }
            object = this.generateResponseAuth(string2, cArray, byArray3, 1, byArray5);
        }
        catch (Throwable throwable) {
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = '\u0000';
            }
            throw throwable;
        }
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = '\u0000';
        }
        return object;
    }

    private static boolean uriMatches(String string, String string2) {
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (string.endsWith("/*")) {
            int n = string.length() - 1;
            String string3 = string.substring(0, n);
            String string4 = string2.substring(0, n);
            return string3.equalsIgnoreCase(string4);
        }
        return false;
    }

    private byte[] generateResponseAuth(String string, char[] cArray, byte[] byArray, int n, byte[] byArray2) throws SaslException {
        try {
            byte[] byArray3 = this.generateResponseValue("", this.digestUri, this.negotiatedQop, string, this.negotiatedRealm, cArray, this.nonce, byArray, n, byArray2);
            byte[] byArray4 = new byte[byArray3.length + 8];
            System.arraycopy("rspauth=".getBytes(this.encoding), 0, byArray4, 0, 8);
            System.arraycopy(byArray3, 0, byArray4, 8, byArray3.length);
            return byArray4;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SaslException("DIGEST-MD5: problem generating response", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            throw new SaslException("DIGEST-MD5: problem generating response", iOException);
        }
    }

    @Override
    public String getAuthorizationID() {
        if (this.completed) {
            return this.authzid;
        }
        throw new IllegalStateException("DIGEST-MD5 server negotiation not complete");
    }
}

