/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableCellRenderer;
import org.openstreetmap.josm.tools.ImageProvider;

public class MemberTableMemberCellRenderer
extends MemberTableCellRenderer {
    protected void renderPrimitive(OsmPrimitive primitive, Dimension cellSize) {
        int size = Math.min(cellSize.width, cellSize.height);
        this.setIcon(ImageProvider.getPadded(primitive, new Dimension(size, size)));
        this.setText(primitive.getDisplayName(DefaultNameFormatter.getInstance()));
        this.setToolTipText(DefaultNameFormatter.getInstance().buildDefaultToolTip(primitive));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.reset();
        if (value == null) {
            return this;
        }
        Dimension cellSize = table.getCellRect(row, column, false).getSize();
        OsmPrimitive primitive = (OsmPrimitive)value;
        this.renderBackgroundForeground(this.getModel(table), primitive, isSelected);
        this.renderPrimitive(primitive, cellSize);
        return this;
    }
}

