/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractUnresolvableReference
implements ILinkingCandidate {
    private final XExpression expression;
    private final ExpressionTypeComputationState state;

    public AbstractUnresolvableReference(XExpression expression, ExpressionTypeComputationState state) {
        this.expression = expression;
        this.state = state;
    }

    @Override
    public XExpression getExpression() {
        return this.expression;
    }

    @Override
    public void applyToComputationState() {
        StackedResolvedTypes resolvedTypes = this.getResolvedTypes();
        resolvedTypes.acceptCandidate(this.expression, this);
        this.computeArgumentTypes();
        this.applyType();
        resolvedTypes.mergeIntoParent();
    }

    protected void applyType() {
        this.state.acceptActualType((LightweightTypeReference)this.state.getReferenceOwner().newUnknownTypeReference(), 0x100200);
    }

    protected ExpressionTypeComputationState getState() {
        return this.state;
    }

    protected StackedResolvedTypes getResolvedTypes() {
        return this.state.getStackedResolvedTypes();
    }

    @Override
    public boolean validate(IAcceptor<? super AbstractDiagnostic> result) {
        return true;
    }

    protected void computeArgumentTypes() {
        List<XExpression> arguments = this.getArguments();
        for (XExpression argument : arguments) {
            if (this.getResolvedTypes().doGetTypeData(argument) != null) continue;
            AbstractTypeComputationState argumentState = this.state.withNonVoidExpectation();
            argumentState.computeTypes(argument);
        }
    }

    protected abstract List<XExpression> getArguments();

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        return other;
    }

    @Override
    public JvmIdentifiableElement getFeature() {
        return null;
    }

    public EObject getContext() {
        return this.expression;
    }
}

