/*
 * Decompiled with CFR 0.152.
 */
package com.hivemq.client.internal.mqtt.handler.publish.outgoing;

import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttAckFlow;
import com.hivemq.client.internal.mqtt.handler.publish.outgoing.MqttPubOrRelWithFlow;
import com.hivemq.client.internal.mqtt.message.publish.MqttPublish;
import com.hivemq.client.internal.mqtt.message.publish.pubrec.MqttPubRec;
import com.hivemq.client.internal.mqtt.message.publish.pubrel.MqttPubRel;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.NotNull;

abstract class MqttPubRelWithFlow
extends MqttPubOrRelWithFlow {
    @NotNull
    private final MqttPubRel pubRel;

    MqttPubRelWithFlow(@NotNull MqttPubRel pubRel, @NotNull MqttAckFlow ackFlow) {
        super(ackFlow);
        this.pubRel = pubRel;
    }

    @NotNull
    MqttPubRel getPubRel() {
        return this.pubRel;
    }

    static class MqttQos2CompleteWithFlow
    extends MqttPubRelWithFlow {
        @NotNull
        private final MqttPublish publish;
        @NotNull
        private final MqttPubRec pubRec;

        MqttQos2CompleteWithFlow(@NotNull MqttPublish publish, @NotNull MqttPubRec pubRec, @NotNull MqttPubRel pubRel, @NotNull MqttAckFlow ackFlow) {
            super(pubRel, ackFlow);
            this.publish = publish;
            this.pubRec = pubRec;
        }

        @NotNull
        MqttPublish getPublish() {
            return this.publish;
        }

        @NotNull
        MqttPubRec getPubRec() {
            return this.pubRec;
        }
    }

    static class MqttQos2IntermediateWithFlow
    extends MqttPubRelWithFlow
    implements BooleanSupplier {
        private int state;

        MqttQos2IntermediateWithFlow(@NotNull MqttPubRel pubRel, @NotNull MqttAckFlow ackFlow) {
            super(pubRel, ackFlow);
        }

        @Override
        public boolean getAsBoolean() {
            return ++this.state == 2;
        }
    }
}

