/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;

public class PurgeDataCommand
extends ComPortCommand {
    private int purgeData;

    public PurgeDataCommand(int[] bytes) {
        super("PURGE-DATA", 12, bytes);
        this.purgeData = bytes[2];
        switch (this.purgeData) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid purge data value " + this.purgeData);
            }
        }
    }

    public PurgeDataCommand(boolean client, int purgeData) {
        this(new int[]{44, client ? 12 : 112, purgeData});
    }

    @Override
    public String toString() {
        String desc;
        switch (this.purgeData) {
            case 1: {
                desc = "RECEIVE-DATA-BUFFER";
                break;
            }
            case 2: {
                desc = "TRANSMIT-DATA-BUFFER";
                break;
            }
            case 3: {
                desc = "BOTH-DATA-BUFFERS";
                break;
            }
            default: {
                desc = "?";
            }
        }
        return this.getName() + " " + desc;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.casePurgeData(this);
    }

    public boolean isPurgeReceiveDataBuffer() {
        return (this.purgeData & 1) != 0;
    }

    public boolean isPurgeTransmitDataBuffer() {
        return (this.purgeData & 2) != 0;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

