/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Trigger;
import org.openhab.core.automation.handler.BaseTriggerModuleHandler;
import org.openhab.core.automation.handler.TriggerHandlerCallback;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFilter;
import org.openhab.core.events.EventSubscriber;
import org.openhab.core.events.TopicEventFilter;
import org.openhab.core.events.TopicPrefixEventFilter;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.GroupItemStateChangedEvent;
import org.openhab.core.items.events.GroupStateUpdatedEvent;
import org.openhab.core.items.events.ItemAddedEvent;
import org.openhab.core.items.events.ItemRemovedEvent;
import org.openhab.core.items.events.ItemStateChangedEvent;
import org.openhab.core.items.events.ItemStateUpdatedEvent;
import org.openhab.core.types.State;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemStateTriggerHandler
extends BaseTriggerModuleHandler
implements EventSubscriber {
    public static final String UPDATE_MODULE_TYPE_ID = "core.ItemStateUpdateTrigger";
    public static final String CHANGE_MODULE_TYPE_ID = "core.ItemStateChangeTrigger";
    public static final String CFG_ITEMNAME = "itemName";
    public static final String CFG_STATE = "state";
    public static final String CFG_PREVIOUS_STATE = "previousState";
    private final Logger logger = LoggerFactory.getLogger(ItemStateTriggerHandler.class);
    private final String itemName;
    private final @Nullable String state;
    private final String previousState;
    private final String ruleUID;
    private Set<String> types;
    private final BundleContext bundleContext;
    private final EventFilter eventFilter;
    private @Nullable ServiceRegistration<?> eventSubscriberRegistration;

    public ItemStateTriggerHandler(Trigger module, String ruleUID, BundleContext bundleContext, ItemRegistry itemRegistry) {
        super(module);
        this.itemName = (String)module.getConfiguration().get(CFG_ITEMNAME);
        boolean isWildcard = this.itemName.contains("?") || this.itemName.contains("*");
        this.eventFilter = isWildcard ? new TopicEventFilter("^openhab/items/" + this.itemName.replace("?", ".?").replace("*", ".*?") + "/.*$") : new TopicPrefixEventFilter("openhab/items/" + this.itemName + "/");
        this.state = (String)module.getConfiguration().get(CFG_STATE);
        this.previousState = (String)module.getConfiguration().get(CFG_PREVIOUS_STATE);
        this.ruleUID = ruleUID;
        this.types = UPDATE_MODULE_TYPE_ID.equals(module.getTypeUID()) ? (isWildcard ? Set.of(ItemStateUpdatedEvent.TYPE, GroupStateUpdatedEvent.TYPE) : Set.of(ItemStateUpdatedEvent.TYPE, GroupStateUpdatedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE)) : (isWildcard ? Set.of(ItemStateChangedEvent.TYPE, GroupItemStateChangedEvent.TYPE) : Set.of(ItemStateChangedEvent.TYPE, GroupItemStateChangedEvent.TYPE, ItemAddedEvent.TYPE, ItemRemovedEvent.TYPE));
        this.bundleContext = bundleContext;
        this.eventSubscriberRegistration = this.bundleContext.registerService(EventSubscriber.class.getName(), (Object)this, null);
        if (!isWildcard && itemRegistry.get((Object)this.itemName) == null) {
            this.logger.warn("Item '{}' needed for rule '{}' is missing. Trigger '{}' will not work.", new Object[]{this.itemName, ruleUID, module.getId()});
        }
    }

    public Set<String> getSubscribedEventTypes() {
        return this.types;
    }

    public @Nullable EventFilter getEventFilter() {
        return this.eventFilter;
    }

    /*
     * Unable to fully structure code
     */
    public void receive(Event event) {
        block12: {
            if (event instanceof ItemAddedEvent) {
                addedEvent = (ItemAddedEvent)event;
                if (this.itemName.equals(addedEvent.getItem().name)) {
                    this.logger.info("Item '{}' needed for rule '{}' added. Trigger '{}' will now work.", new Object[]{this.itemName, this.ruleUID, ((Trigger)this.module).getId()});
                    return;
                }
            } else if (event instanceof ItemRemovedEvent) {
                removedEvent = (ItemRemovedEvent)event;
                if (this.itemName.equals(removedEvent.getItem().name)) {
                    this.logger.warn("Item '{}' needed for rule '{}' removed. Trigger '{}' will no longer work.", new Object[]{this.itemName, this.ruleUID, ((Trigger)this.module).getId()});
                    return;
                }
            }
            if ((callback = this.callback) == null) break block12;
            this.logger.trace("Received Event: Source: {} Topic: {} Type: {}  Payload: {}", new Object[]{event.getSource(), event.getTopic(), event.getType(), event.getPayload()});
            values = new HashMap<String, Object>();
            if (!(event instanceof ItemStateUpdatedEvent)) ** GOTO lbl-1000
            updatedEvent = (ItemStateUpdatedEvent)event;
            if ("core.ItemStateUpdateTrigger".equals(((Trigger)this.module).getTypeUID())) {
                state = this.state;
                itemState = updatedEvent.getItemState();
                if (state == null || state.equals(itemState.toFullString())) {
                    values.put("state", itemState);
                    values.put("lastStateUpdate", updatedEvent.getLastStateUpdate());
                }
            } else if (event instanceof ItemStateChangedEvent) {
                changedEvent = (ItemStateChangedEvent)event;
                if ("core.ItemStateChangeTrigger".equals(((Trigger)this.module).getTypeUID())) {
                    itemState = changedEvent.getItemState();
                    oldItemState = changedEvent.getOldItemState();
                    if (this.stateMatches(this.state, itemState) && this.stateMatches(this.previousState, oldItemState)) {
                        values.put("oldState", oldItemState);
                        values.put("newState", itemState);
                        values.put("lastStateUpdate", changedEvent.getLastStateUpdate());
                        values.put("lastStateChange", changedEvent.getLastStateChange());
                    }
                }
            }
            if (!values.isEmpty()) {
                values.put("event", event);
                ((TriggerHandlerCallback)callback).triggered((Trigger)this.module, values);
            }
        }
    }

    private boolean stateMatches(@Nullable String requiredState, State state) {
        if (requiredState == null) {
            return true;
        }
        String reqState = requiredState.trim();
        return reqState.isEmpty() || reqState.equals(state.toFullString());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.eventSubscriberRegistration != null) {
            this.eventSubscriberRegistration.unregister();
            this.eventSubscriberRegistration = null;
        }
    }
}

