/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OrdinalCalculator {
    public static <T extends Comparable<T>> void putOrdinalsInPosition(List<T> list, Collection<Integer> ordinals) {
        int size = list.size();
        if (size == 0) {
            return;
        }
        int[] ords = new int[ordinals.size()];
        int i = 0;
        for (int ord2 : ordinals) {
            ords[i++] = ord2;
        }
        ords = Arrays.stream(ords).sorted().filter(ord -> ord >= 0 && ord < size).toArray();
        OrdinalCalculator.distributeAndFind(list, ords, 0, ords.length - 1);
    }

    private static <T extends Comparable<T>> void distributeAndFind(List<T> list, int[] ordinals, int beginIdx, int endIdx) {
        if (endIdx < beginIdx) {
            return;
        }
        int middleIdxb = beginIdx;
        int middleIdxe = beginIdx;
        int begin = beginIdx == 0 ? -1 : ordinals[beginIdx - 1];
        int end = endIdx == ordinals.length - 1 ? list.size() : ordinals[endIdx + 1];
        double middle = (double)(begin + end) / 2.0;
        for (int i = beginIdx; i <= endIdx; ++i) {
            double value = Math.abs((double)ordinals[i] - middle) - Math.abs((double)ordinals[middleIdxb] - middle);
            if (ordinals[i] == ordinals[middleIdxb]) {
                middleIdxe = i;
                continue;
            }
            if (!(value < 0.0)) continue;
            middleIdxb = i;
            do {
                middleIdxe = i++;
            } while (i <= endIdx && ordinals[middleIdxb] == ordinals[i]);
            break;
        }
        int middlePlace = ordinals[middleIdxb];
        int beginPlace = begin + 1;
        int endPlace = end - 1;
        OrdinalCalculator.select(list, middlePlace, beginPlace, endPlace);
        OrdinalCalculator.distributeAndFind(list, ordinals, beginIdx, middleIdxb - 1);
        OrdinalCalculator.distributeAndFind(list, ordinals, middleIdxe + 1, endIdx);
    }

    private static <T extends Comparable<T>> void select(List<T> list, int place, int begin, int end) {
        Object split = end - begin < 10 ? (Comparable)list.get((int)(Math.random() * (double)(end - begin + 1)) + begin) : OrdinalCalculator.split(list, begin, end);
        Point result = OrdinalCalculator.partition(list, begin, end, split);
        if (place <= result.low) {
            OrdinalCalculator.select(list, place, begin, result.low);
        } else if (place >= result.high) {
            OrdinalCalculator.select(list, place, result.high, end);
        }
    }

    private static <T extends Comparable<T>> T split(List<T> list, int begin, int end) {
        int num = end - begin + 1;
        int recursiveSize = (int)Math.sqrt(num);
        int step = num / recursiveSize;
        for (int i = 1; i < recursiveSize; ++i) {
            int swapFrom = i * step + begin;
            int swapTo = i + begin;
            Comparable temp = (Comparable)list.get(swapFrom);
            list.set(swapFrom, (Comparable)list.get(swapTo));
            list.set(swapTo, temp);
        }
        OrdinalCalculator.select(list, --recursiveSize / 2 + begin, begin, recursiveSize + begin);
        return (T)((Comparable)list.get(recursiveSize / 2 + begin));
    }

    private static <T extends Comparable<T>> Point partition(List<T> list, int begin, int end, T indexElement) {
        Comparable temp;
        int right;
        int left = begin;
        for (right = end; left <= right; ++left, --right) {
            while (((Comparable)list.get(left)).compareTo(indexElement) < 0) {
                ++left;
            }
            while (right != begin - 1 && ((Comparable)list.get(right)).compareTo(indexElement) >= 0) {
                --right;
            }
            if (right <= left) {
                --left;
                ++right;
                break;
            }
            temp = (Comparable)list.get(left);
            list.set(left, (Comparable)list.get(right));
            list.set(right, temp);
        }
        while (left > begin - 1 && ((Comparable)list.get(left)).compareTo(indexElement) >= 0) {
            --left;
        }
        while (right < end + 1 && ((Comparable)list.get(right)).compareTo(indexElement) <= 0) {
            ++right;
        }
        for (int rightMove = right + 1; rightMove < end + 1; ++rightMove) {
            if (!((Comparable)list.get(rightMove)).equals(indexElement)) continue;
            temp = (Comparable)list.get(rightMove);
            list.set(rightMove, (Comparable)list.get(right));
            list.set(right, temp);
            while (((Comparable)list.get(++right)).equals(indexElement)) {
            }
            if (rightMove > right) continue;
            rightMove = right;
        }
        return new Point(left, right);
    }

    static class Point {
        public int low;
        public int high;

        public Point(int low, int high) {
            this.low = low;
            this.high = high;
        }
    }
}

