/*
 * Decompiled with CFR 0.152.
 */
package org.openide.execution;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import org.openide.execution.ExecutorTask;
import org.openide.execution.NbClassPath;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

public abstract class ExecutionEngine {
    public abstract ExecutorTask execute(String var1, Runnable var2, InputOutput var3);

    protected abstract PermissionCollection createPermissions(CodeSource var1, InputOutput var2);

    @Deprecated
    protected abstract NbClassPath createLibraryPath();

    public static ExecutionEngine getDefault() {
        ExecutionEngine executionEngine = (ExecutionEngine)Lookup.getDefault().lookup(ExecutionEngine.class);
        if (executionEngine == null) {
            executionEngine = new Trivial();
        }
        return executionEngine;
    }

    static final class Trivial
    extends ExecutionEngine {
        @Override
        protected NbClassPath createLibraryPath() {
            return new NbClassPath(new String[0]);
        }

        @Override
        protected PermissionCollection createPermissions(CodeSource codeSource, InputOutput inputOutput) {
            Permissions permissions = new Permissions();
            ((PermissionCollection)permissions).add(new AllPermission());
            permissions.setReadOnly();
            return permissions;
        }

        @Override
        public ExecutorTask execute(String string, Runnable runnable, InputOutput inputOutput) {
            return new ET(runnable, string, inputOutput);
        }

        private static final class ET
        extends ExecutorTask {
            private final Lookup originalLookup = Lookup.getDefault();
            private RequestProcessor.Task task;
            private int resultValue = this.resultValue;
            private final String name;
            private final InputOutput io;

            public ET(Runnable runnable, String string, InputOutput inputOutput) {
                super(runnable);
                this.name = string;
                this.io = inputOutput;
                this.task = RequestProcessor.getDefault().post((Runnable)((Object)this));
            }

            @Override
            public void stop() {
                this.task.cancel();
            }

            @Override
            public int result() {
                this.waitFinished();
                return this.resultValue;
            }

            @Override
            public InputOutput getInputOutput() {
                return this.io;
            }

            public void run() {
                Lookups.executeWith((Lookup)this.originalLookup, () -> {
                    try {
                        super.run();
                    }
                    catch (RuntimeException runtimeException) {
                        runtimeException.printStackTrace();
                        this.resultValue = 1;
                    }
                });
            }
        }
    }
}

