/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.view.ComponentMaximiser;

public class ComponentMaximiserMouseListener
extends MouseAdapter {
    private static final Logger LOGGER = LogManager.getLogger(ComponentMaximiserMouseListener.class);
    private static final String DOUBLE_CLICK_WARN_MESSAGE = Constant.messages.getString("tab.doubleClick.warning");
    private final OptionsParamView viewOptions;
    private ComponentMaximiser componentMaximiser;

    public ComponentMaximiserMouseListener(OptionsParamView viewOptions) {
        this(viewOptions, null);
    }

    public ComponentMaximiserMouseListener(OptionsParamView viewOptions, ComponentMaximiser componentMaximiser) {
        if (viewOptions == null) {
            throw new IllegalArgumentException("Parameter viewOptions must not be null.");
        }
        this.viewOptions = viewOptions;
        this.setComponentMaximiser(componentMaximiser);
    }

    public void setComponentMaximiser(ComponentMaximiser componentMaximiser) {
        this.componentMaximiser = componentMaximiser;
    }

    public ComponentMaximiser getComponentMaximiser() {
        return this.componentMaximiser;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.triggerMaximisation((Component)evt.getSource());
        }
    }

    public void triggerMaximisation(Component component) {
        if (this.componentMaximiser == null) {
            return;
        }
        if (this.componentMaximiser.isComponentMaximised()) {
            this.componentMaximiser.unmaximiseComponent();
        } else if (this.confirmMaximisation()) {
            this.componentMaximiser.maximiseComponent(component);
        }
    }

    private boolean confirmMaximisation() {
        if (!this.viewOptions.getWarnOnTabDoubleClick()) {
            return true;
        }
        if (View.getSingleton().showConfirmDialog(DOUBLE_CLICK_WARN_MESSAGE) != 0) {
            return false;
        }
        this.viewOptions.setWarnOnTabDoubleClick(false);
        try {
            this.viewOptions.getConfig().save();
        }
        catch (ConfigurationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

