/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.IndexColumnTable;
import ca.sqlpower.architect.swingui.Messages;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sql.JDBCDataSourceType;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class IndexEditPanel
extends ChangeListeningDataEntryPanel
implements SPListener {
    protected SQLIndex index;
    protected SQLTable parent;
    protected SQLIndex indexCopy;
    JTextField name;
    JCheckBox unique;
    JCheckBox primaryKey;
    JComboBox indexType;
    JCheckBox clustered;
    IndexColumnTable columnsTable;
    private JPanel panel = new JPanel((LayoutManager)new FormLayout("pref,4dlu,pref,4dlu,pref:grow,4dlu,pref", "pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref,4dlu,pref:grow,4dlu,pref,4dlu"));
    ArchitectSwingSession session;
    private static String DEFAULT_INDEX_TYPE = Messages.getString("IndexEditPanel.defaultIndexType");

    public IndexEditPanel(SQLIndex index, ArchitectSwingSession session) throws SQLObjectException {
        this(index, index.getParent(), session);
    }

    public IndexEditPanel(SQLIndex index, SQLTable parent, ArchitectSwingSession session) throws SQLObjectException {
        this.session = session;
        SQLPowerUtils.listenToHierarchy((SPObject)index, (SPListener)this);
        this.createGUI(index, parent, session);
    }

    private void createGUI(SQLIndex index, SQLTable parent, ArchitectSwingSession session) throws SQLObjectException {
        this.parent = parent;
        PanelBuilder pb = new PanelBuilder((FormLayout)this.panel.getLayout(), this.panel);
        CellConstraints cc = new CellConstraints();
        pb.add((Component)new JLabel(Messages.getString("IndexEditPanel.indexName")), cc.xy(1, 1));
        this.name = new JTextField("", 30);
        pb.add((Component)this.name, cc.xyw(3, 1, 4));
        this.unique = new JCheckBox(Messages.getString("IndexEditPanel.uniqueIndex"));
        pb.add((Component)this.unique, cc.xy(3, 3));
        this.primaryKey = new JCheckBox(Messages.getString("IndexEditPanel.primaryKeyIndex"));
        pb.add((Component)this.primaryKey, cc.xy(3, 5));
        this.clustered = new JCheckBox(Messages.getString("IndexEditPanel.clusteredIndex"));
        this.clustered.setSelected(index.isClustered());
        pb.add((Component)this.clustered, cc.xy(3, 7));
        pb.add((Component)new JLabel(Messages.getString("IndexEditPanel.indexType")), cc.xy(1, 9));
        this.indexType = new JComboBox();
        this.indexType.addItem(DEFAULT_INDEX_TYPE);
        for (String type : this.getIndexTypes()) {
            this.indexType.addItem(type);
        }
        pb.add((Component)this.indexType, cc.xyw(3, 9, 4));
        this.editIndex(index);
        this.columnsTable = new IndexColumnTable(parent, this.indexCopy, index);
        pb.add((Component)new JScrollPane(this.columnsTable.getTable()), cc.xyw(1, 13, 6));
        JPanel upDownPanel = new JPanel(new FlowLayout(0));
        upDownPanel.add(new JButton(new AbstractAction(null, SPSUtils.createIcon((String)"chevrons_up1", null)){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditPanel.this.columnsTable.moveRow(true);
            }
        }));
        upDownPanel.add(new JButton(new AbstractAction(null, SPSUtils.createIcon((String)"chevrons_down1", null)){

            @Override
            public void actionPerformed(ActionEvent e) {
                IndexEditPanel.this.columnsTable.moveRow(false);
            }
        }));
        pb.add((Component)upDownPanel, cc.xyw(1, 15, 6));
        this.loadIndexIntoPanel();
    }

    private String getIndexName() {
        int i = 0;
        String name = null;
        do {
            name = this.generateName(i);
            ++i;
        } while (this.indexNameAlreadyExists(name));
        return name;
    }

    private boolean indexNameAlreadyExists(String name) {
        try {
            for (SQLIndex index : this.parent.getIndices()) {
                if (!name.equals(index.getName())) continue;
                return true;
            }
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
        return false;
    }

    private String generateName(int number) {
        if (number == 0) {
            return new String(this.parent.getName() + "_idx");
        }
        return new String(this.parent.getName() + "_idx" + Integer.toString(number));
    }

    private List<String> getIndexTypes() {
        ArrayList<String> indexTypes = new ArrayList<String>();
        List dsTypes = this.session.getDataSources().getDataSourceTypes();
        for (JDBCDataSourceType dsType : dsTypes) {
            String supportedType;
            int dataTypeCount = 0;
            while ((supportedType = dsType.getProperty(SQLIndex.INDEX_TYPE_DESCRIPTOR + "_" + dataTypeCount)) != null) {
                if (!indexTypes.contains(supportedType)) {
                    indexTypes.add(supportedType);
                }
                ++dataTypeCount;
            }
        }
        return indexTypes;
    }

    public void editIndex(SQLIndex index) throws SQLObjectException {
        this.index = index;
        this.name.setText(index.getName());
        this.indexCopy = new SQLIndex(index);
        this.indexCopy.setParent(null);
    }

    private void loadIndexIntoPanel() {
        if (this.index.getName() != null) {
            this.name.setText(this.index.getName());
        } else {
            this.name.setText(this.getIndexName());
        }
        this.primaryKey.setSelected(this.index.isPrimaryKeyIndex());
        this.primaryKey.setEnabled(false);
        this.unique.setSelected(this.index.isUnique());
        this.clustered.setSelected(this.index.isClustered());
        if (this.index.getType() == null) {
            this.indexType.setSelectedItem(DEFAULT_INDEX_TYPE);
        } else {
            this.indexType.setSelectedItem(this.index.getType());
        }
        this.name.selectAll();
    }

    protected SQLIndex getIndexCopy() {
        return this.indexCopy;
    }

    public boolean applyChanges() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.index, (SPListener)this);
        this.columnsTable.cleanUp();
        this.columnsTable.finalizeIndex();
        this.parent.begin(Messages.getString("IndexEditPanel.compoundEditName"));
        try {
            StringBuffer warnings = new StringBuffer();
            if (this.name.getText().trim().length() == 0) {
                warnings.append(Messages.getString("IndexEditPanel.blankIndexName"));
            }
            if (this.index.isPrimaryKeyIndex()) {
                for (SQLIndex.Column c : this.indexCopy.getChildren(SQLIndex.Column.class)) {
                    if (c.getColumn() != null) continue;
                    warnings.append(Messages.getString("IndexEditPanel.onlyAddColumnsToPK"));
                    break;
                }
            }
            if (this.indexType.getSelectedItem() == null) {
                warnings.append(Messages.getString("IndexEditPanel.mustSelectIndexType"));
            }
            if (warnings.toString().length() == 0) {
                this.index.makeColumnsLike(this.indexCopy);
                SQLTable parentTable = this.parent;
                this.index.setName(this.name.getText().trim());
                this.index.setPhysicalName(this.name.getText().trim());
                this.index.setUnique(this.unique.isSelected());
                this.index.setClustered(this.clustered.isSelected());
                if (this.indexType.getSelectedItem().toString().equals(DEFAULT_INDEX_TYPE)) {
                    this.index.setType(null);
                } else {
                    this.index.setType(this.indexType.getSelectedItem().toString());
                }
                List children = parentTable.getIndices();
                if (!children.contains(this.index)) {
                    parentTable.addIndex(this.index);
                }
                this.index.cleanUpIfChildless();
                boolean bl = true;
                return bl;
            }
            JOptionPane.showMessageDialog(this.panel, warnings.toString());
            boolean bl = false;
            return bl;
        }
        catch (SQLObjectException e) {
            throw new SQLObjectRuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.parent.commit();
        }
    }

    public void discardChanges() {
        SQLPowerUtils.unlistenToHierarchy((SPObject)this.index, (SPListener)this);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public String getNameText() {
        return this.name.getText();
    }

    public void setNameText(String newName) {
        this.name.setText(newName);
    }

    public boolean hasUnsavedChanges() {
        return true;
    }

    public void childAdded(SPChildEvent e) {
        if (e.getSource() == this.index) {
            this.columnsTable.getTable().setBackground(DataEntryPanelChangeUtil.NONCONFLICTING_COLOR);
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        }
    }

    public void childRemoved(SPChildEvent e) {
        if (e.getSource() == this.index) {
            this.columnsTable.getTable().setBackground(DataEntryPanelChangeUtil.NONCONFLICTING_COLOR);
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        boolean error = false;
        if (e.getSource() == this.index) {
            if (property.equals("name")) {
                error = DataEntryPanelChangeUtil.incomingChange((JTextComponent)this.name, (PropertyChangeEvent)e);
            } else if (property.equals("unique")) {
                error = DataEntryPanelChangeUtil.incomingChange((JCheckBox)this.unique, (PropertyChangeEvent)e);
            } else if (property.equals("clustered")) {
                error = DataEntryPanelChangeUtil.incomingChange((JCheckBox)this.clustered, (PropertyChangeEvent)e);
            } else if (property.equals("type")) {
                Object oldValue = e.getOldValue();
                Object newValue = e.getNewValue();
                if (oldValue == null || oldValue.equals("")) {
                    oldValue = "Platform Default";
                }
                if (newValue == null || oldValue.equals("")) {
                    newValue = "Platform Default";
                }
                error = DataEntryPanelChangeUtil.incomingChange((JComboBox)this.indexType, (PropertyChangeEvent)new PropertyChangeEvent(e.getSource(), e.getPropertyName(), oldValue, newValue));
            }
        } else if (e.getSource() instanceof SQLIndex.Column && property.equals("ascendingOrDescending")) {
            this.columnsTable.getTable().setBackground(DataEntryPanelChangeUtil.NONCONFLICTING_COLOR);
            error = true;
        }
        if (error) {
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        }
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public void transactionStarted(TransactionEvent e) {
    }
}

