/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputLocationTracker;
import org.apache.maven.model.Reporting;
import org.apache.maven.model.Repository;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class ModelBase
implements Serializable,
Cloneable,
InputLocationTracker {
    private List<String> modules;
    private DistributionManagement distributionManagement;
    private Properties properties;
    private DependencyManagement dependencyManagement;
    private List<Dependency> dependencies;
    private List<Repository> repositories;
    private List<Repository> pluginRepositories;
    private Object reports;
    private Reporting reporting;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation modulesLocation;
    private InputLocation distributionManagementLocation;
    private InputLocation propertiesLocation;
    private InputLocation dependencyManagementLocation;
    private InputLocation dependenciesLocation;
    private InputLocation repositoriesLocation;
    private InputLocation pluginRepositoriesLocation;
    private InputLocation reportsLocation;
    private InputLocation reportingLocation;

    public void addDependency(Dependency dependency) {
        this.getDependencies().add(dependency);
    }

    public void addModule(String string2) {
        this.getModules().add(string2);
    }

    public void addPluginRepository(Repository repository) {
        this.getPluginRepositories().add(repository);
    }

    public void addProperty(String key2, String value) {
        this.getProperties().put(key2, value);
    }

    public void addRepository(Repository repository) {
        this.getRepositories().add(repository);
    }

    public ModelBase clone() {
        try {
            ModelBase copy2 = (ModelBase)super.clone();
            if (this.modules != null) {
                copy2.modules = new ArrayList<String>();
                copy2.modules.addAll(this.modules);
            }
            if (this.distributionManagement != null) {
                copy2.distributionManagement = this.distributionManagement.clone();
            }
            if (this.properties != null) {
                copy2.properties = (Properties)this.properties.clone();
            }
            if (this.dependencyManagement != null) {
                copy2.dependencyManagement = this.dependencyManagement.clone();
            }
            if (this.dependencies != null) {
                copy2.dependencies = new ArrayList<Dependency>();
                for (Dependency dependency : this.dependencies) {
                    copy2.dependencies.add(dependency.clone());
                }
            }
            if (this.repositories != null) {
                copy2.repositories = new ArrayList<Repository>();
                for (Repository repository : this.repositories) {
                    copy2.repositories.add(repository.clone());
                }
            }
            if (this.pluginRepositories != null) {
                copy2.pluginRepositories = new ArrayList<Repository>();
                for (Repository repository : this.pluginRepositories) {
                    copy2.pluginRepositories.add(repository.clone());
                }
            }
            if (this.reports != null) {
                copy2.reports = new Xpp3Dom((Xpp3Dom)this.reports);
            }
            if (this.reporting != null) {
                copy2.reporting = this.reporting.clone();
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public List<Dependency> getDependencies() {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<Dependency>();
        }
        return this.dependencies;
    }

    public DependencyManagement getDependencyManagement() {
        return this.dependencyManagement;
    }

    public DistributionManagement getDistributionManagement() {
        return this.distributionManagement;
    }

    @Override
    public InputLocation getLocation(Object key2) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    return this.location;
                }
                case "modules": {
                    return this.modulesLocation;
                }
                case "distributionManagement": {
                    return this.distributionManagementLocation;
                }
                case "properties": {
                    return this.propertiesLocation;
                }
                case "dependencyManagement": {
                    return this.dependencyManagementLocation;
                }
                case "dependencies": {
                    return this.dependenciesLocation;
                }
                case "repositories": {
                    return this.repositoriesLocation;
                }
                case "pluginRepositories": {
                    return this.pluginRepositoriesLocation;
                }
                case "reports": {
                    return this.reportsLocation;
                }
                case "reporting": {
                    return this.reportingLocation;
                }
            }
            return this.getOtherLocation(key2);
        }
        return this.getOtherLocation(key2);
    }

    public List<String> getModules() {
        if (this.modules == null) {
            this.modules = new ArrayList<String>();
        }
        return this.modules;
    }

    @Override
    public void setLocation(Object key2, InputLocation location) {
        if (key2 instanceof String) {
            switch ((String)key2) {
                case "": {
                    this.location = location;
                    return;
                }
                case "modules": {
                    this.modulesLocation = location;
                    return;
                }
                case "distributionManagement": {
                    this.distributionManagementLocation = location;
                    return;
                }
                case "properties": {
                    this.propertiesLocation = location;
                    return;
                }
                case "dependencyManagement": {
                    this.dependencyManagementLocation = location;
                    return;
                }
                case "dependencies": {
                    this.dependenciesLocation = location;
                    return;
                }
                case "repositories": {
                    this.repositoriesLocation = location;
                    return;
                }
                case "pluginRepositories": {
                    this.pluginRepositoriesLocation = location;
                    return;
                }
                case "reports": {
                    this.reportsLocation = location;
                    return;
                }
                case "reporting": {
                    this.reportingLocation = location;
                    return;
                }
            }
            this.setOtherLocation(key2, location);
            return;
        }
        this.setOtherLocation(key2, location);
    }

    public void setOtherLocation(Object key2, InputLocation location) {
        if (location != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key2, location);
        }
    }

    private InputLocation getOtherLocation(Object key2) {
        return this.locations != null ? this.locations.get(key2) : null;
    }

    public List<Repository> getPluginRepositories() {
        if (this.pluginRepositories == null) {
            this.pluginRepositories = new ArrayList<Repository>();
        }
        return this.pluginRepositories;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public Reporting getReporting() {
        return this.reporting;
    }

    public Object getReports() {
        return this.reports;
    }

    public List<Repository> getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList<Repository>();
        }
        return this.repositories;
    }

    public void removeDependency(Dependency dependency) {
        this.getDependencies().remove(dependency);
    }

    public void removeModule(String string2) {
        this.getModules().remove(string2);
    }

    public void removePluginRepository(Repository repository) {
        this.getPluginRepositories().remove(repository);
    }

    public void removeRepository(Repository repository) {
        this.getRepositories().remove(repository);
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public void setDependencyManagement(DependencyManagement dependencyManagement) {
        this.dependencyManagement = dependencyManagement;
    }

    public void setDistributionManagement(DistributionManagement distributionManagement) {
        this.distributionManagement = distributionManagement;
    }

    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    public void setPluginRepositories(List<Repository> pluginRepositories) {
        this.pluginRepositories = pluginRepositories;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setReporting(Reporting reporting) {
        this.reporting = reporting;
    }

    public void setReports(Object reports) {
        this.reports = reports;
    }

    public void setRepositories(List<Repository> repositories) {
        this.repositories = repositories;
    }
}

