/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.dom.mutation;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.declarativedsl.dom.mutation.Digraph;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0011\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u000e\u001a\u00020\fJ\u0016\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/gradle/internal/declarativedsl/dom/mutation/MarkedStates;", "", "size", "", "(I)V", "marked", "", "getSize", "()I", "clear", "", "get", "", "vertex", "last", "mark", "graph", "Lorg/gradle/internal/declarativedsl/dom/mutation/Digraph;", "toString", "", "declarative-dsl-core"})
final class MarkedStates {
    private final int size;
    @NotNull
    private final boolean[] marked;

    public MarkedStates(int size) {
        this.size = size;
        int n = 0;
        int n2 = this.size;
        boolean[] blArray = new boolean[n2];
        MarkedStates markedStates = this;
        while (n < n2) {
            int n3 = n++;
            blArray[n3] = false;
        }
        markedStates.marked = blArray;
    }

    public final int getSize() {
        return this.size;
    }

    public final void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.marked[i] = false;
        }
    }

    public final void mark(@NotNull Digraph graph, int vertex) {
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        this.marked[vertex] = true;
        Iterator<Integer> iterator = graph.adjacentVertices(vertex).iterator();
        while (iterator.hasNext()) {
            int w = ((Number)iterator.next()).intValue();
            if (this.marked[w]) continue;
            this.mark(graph, w);
        }
    }

    public final boolean last() {
        return ArraysKt.last((boolean[])this.marked);
    }

    public final boolean get(int vertex) {
        return this.marked[vertex];
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$toString_u24lambda_u240.append("Reachable states out of " + this.size + ':');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder3 = $this$toString_u24lambda_u240.append("" + '\t' + i + " -> " + this.marked[i]);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

