/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.assimp.AIColor3D;
import org.lwjgl.assimp.AIString;
import org.lwjgl.assimp.AIVector2D;
import org.lwjgl.assimp.AIVector3D;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiLight")
public class AILight
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MTYPE;
    public static final int MPOSITION;
    public static final int MDIRECTION;
    public static final int MUP;
    public static final int MATTENUATIONCONSTANT;
    public static final int MATTENUATIONLINEAR;
    public static final int MATTENUATIONQUADRATIC;
    public static final int MCOLORDIFFUSE;
    public static final int MCOLORSPECULAR;
    public static final int MCOLORAMBIENT;
    public static final int MANGLEINNERCONE;
    public static final int MANGLEOUTERCONE;
    public static final int MSIZE;

    public AILight(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AILight.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AILight.nmName(this.address());
    }

    @NativeType(value="aiLightSourceType")
    public int mType() {
        return AILight.nmType(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mPosition() {
        return AILight.nmPosition(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mDirection() {
        return AILight.nmDirection(this.address());
    }

    @NativeType(value="struct aiVector3D")
    public AIVector3D mUp() {
        return AILight.nmUp(this.address());
    }

    public float mAttenuationConstant() {
        return AILight.nmAttenuationConstant(this.address());
    }

    public float mAttenuationLinear() {
        return AILight.nmAttenuationLinear(this.address());
    }

    public float mAttenuationQuadratic() {
        return AILight.nmAttenuationQuadratic(this.address());
    }

    @NativeType(value="struct aiColor3D")
    public AIColor3D mColorDiffuse() {
        return AILight.nmColorDiffuse(this.address());
    }

    @NativeType(value="struct aiColor3D")
    public AIColor3D mColorSpecular() {
        return AILight.nmColorSpecular(this.address());
    }

    @NativeType(value="struct aiColor3D")
    public AIColor3D mColorAmbient() {
        return AILight.nmColorAmbient(this.address());
    }

    public float mAngleInnerCone() {
        return AILight.nmAngleInnerCone(this.address());
    }

    public float mAngleOuterCone() {
        return AILight.nmAngleOuterCone(this.address());
    }

    @NativeType(value="struct aiVector2D")
    public AIVector2D mSize() {
        return AILight.nmSize(this.address());
    }

    public static AILight create(long address) {
        return (AILight)AILight.wrap(AILight.class, (long)address);
    }

    @Nullable
    public static AILight createSafe(long address) {
        return address == 0L ? null : (AILight)AILight.wrap(AILight.class, (long)address);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)AILight.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)AILight.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static int nmType(long struct) {
        return UNSAFE.getInt(null, struct + (long)MTYPE);
    }

    public static AIVector3D nmPosition(long struct) {
        return AIVector3D.create(struct + (long)MPOSITION);
    }

    public static AIVector3D nmDirection(long struct) {
        return AIVector3D.create(struct + (long)MDIRECTION);
    }

    public static AIVector3D nmUp(long struct) {
        return AIVector3D.create(struct + (long)MUP);
    }

    public static float nmAttenuationConstant(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MATTENUATIONCONSTANT);
    }

    public static float nmAttenuationLinear(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MATTENUATIONLINEAR);
    }

    public static float nmAttenuationQuadratic(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MATTENUATIONQUADRATIC);
    }

    public static AIColor3D nmColorDiffuse(long struct) {
        return AIColor3D.create(struct + (long)MCOLORDIFFUSE);
    }

    public static AIColor3D nmColorSpecular(long struct) {
        return AIColor3D.create(struct + (long)MCOLORSPECULAR);
    }

    public static AIColor3D nmColorAmbient(long struct) {
        return AIColor3D.create(struct + (long)MCOLORAMBIENT);
    }

    public static float nmAngleInnerCone(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MANGLEINNERCONE);
    }

    public static float nmAngleOuterCone(long struct) {
        return UNSAFE.getFloat(null, struct + (long)MANGLEOUTERCONE);
    }

    public static AIVector2D nmSize(long struct) {
        return AIVector2D.create(struct + (long)MSIZE);
    }

    static {
        Struct.Layout layout = AILight.__struct((Struct.Member[])new Struct.Member[]{AILight.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AILight.__member((int)4), AILight.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AILight.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AILight.__member((int)AIVector3D.SIZEOF, (int)AIVector3D.ALIGNOF), AILight.__member((int)4), AILight.__member((int)4), AILight.__member((int)4), AILight.__member((int)AIColor3D.SIZEOF, (int)AIColor3D.ALIGNOF), AILight.__member((int)AIColor3D.SIZEOF, (int)AIColor3D.ALIGNOF), AILight.__member((int)AIColor3D.SIZEOF, (int)AIColor3D.ALIGNOF), AILight.__member((int)4), AILight.__member((int)4), AILight.__member((int)AIVector2D.SIZEOF, (int)AIVector2D.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MTYPE = layout.offsetof(1);
        MPOSITION = layout.offsetof(2);
        MDIRECTION = layout.offsetof(3);
        MUP = layout.offsetof(4);
        MATTENUATIONCONSTANT = layout.offsetof(5);
        MATTENUATIONLINEAR = layout.offsetof(6);
        MATTENUATIONQUADRATIC = layout.offsetof(7);
        MCOLORDIFFUSE = layout.offsetof(8);
        MCOLORSPECULAR = layout.offsetof(9);
        MCOLORAMBIENT = layout.offsetof(10);
        MANGLEINNERCONE = layout.offsetof(11);
        MANGLEOUTERCONE = layout.offsetof(12);
        MSIZE = layout.offsetof(13);
    }

    public static class Buffer
    extends StructBuffer<AILight, Buffer> {
        private static final AILight ELEMENT_FACTORY = AILight.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected AILight getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AILight.nmName(this.address());
        }

        @NativeType(value="aiLightSourceType")
        public int mType() {
            return AILight.nmType(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mPosition() {
            return AILight.nmPosition(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mDirection() {
            return AILight.nmDirection(this.address());
        }

        @NativeType(value="struct aiVector3D")
        public AIVector3D mUp() {
            return AILight.nmUp(this.address());
        }

        public float mAttenuationConstant() {
            return AILight.nmAttenuationConstant(this.address());
        }

        public float mAttenuationLinear() {
            return AILight.nmAttenuationLinear(this.address());
        }

        public float mAttenuationQuadratic() {
            return AILight.nmAttenuationQuadratic(this.address());
        }

        @NativeType(value="struct aiColor3D")
        public AIColor3D mColorDiffuse() {
            return AILight.nmColorDiffuse(this.address());
        }

        @NativeType(value="struct aiColor3D")
        public AIColor3D mColorSpecular() {
            return AILight.nmColorSpecular(this.address());
        }

        @NativeType(value="struct aiColor3D")
        public AIColor3D mColorAmbient() {
            return AILight.nmColorAmbient(this.address());
        }

        public float mAngleInnerCone() {
            return AILight.nmAngleInnerCone(this.address());
        }

        public float mAngleOuterCone() {
            return AILight.nmAngleOuterCone(this.address());
        }

        @NativeType(value="struct aiVector2D")
        public AIVector2D mSize() {
            return AILight.nmSize(this.address());
        }
    }
}

