/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.xml.text.navigator.TreeNodeAdapter;
import org.openide.awt.HtmlRenderer;
import org.openide.util.ImageUtilities;

public class NavigatorTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final String TAG_16 = "org/netbeans/modules/xml/text/navigator/resources/tag.png";
    private static final String PI_16 = "org/netbeans/modules/xml/text/navigator/resources/xml_declaration.png";
    private static final String DOCTYPE_16 = "org/netbeans/modules/xml/text/navigator/resources/doc_type.png";
    private static final String CDATA_16 = "org/netbeans/modules/xml/text/navigator/resources/cdata.png";
    private static final String ERROR_16 = "org/netbeans/modules/xml/text/navigator/resources/badge_error.png";
    private final Icon ERROR_ICON = ImageUtilities.loadIcon((String)"org/netbeans/modules/xml/text/navigator/resources/badge_error.png", (boolean)true);
    private final Icon[] TAG_ICON = new Icon[]{this.getIcon("org/netbeans/modules/xml/text/navigator/resources/tag.png", false), this.getIcon("org/netbeans/modules/xml/text/navigator/resources/tag.png", true)};
    private final Icon[] PI_ICON = new Icon[]{this.getIcon("org/netbeans/modules/xml/text/navigator/resources/xml_declaration.png", false), this.getIcon("org/netbeans/modules/xml/text/navigator/resources/xml_declaration.png", true)};
    private final Icon[] DOCTYPE_ICON = new Icon[]{this.getIcon("org/netbeans/modules/xml/text/navigator/resources/doc_type.png", false), this.getIcon("org/netbeans/modules/xml/text/navigator/resources/doc_type.png", true)};
    private final Icon[] CDATA_ICON = new Icon[]{this.getIcon("org/netbeans/modules/xml/text/navigator/resources/cdata.png", false), this.getIcon("org/netbeans/modules/xml/text/navigator/resources/cdata.png", true)};
    private HtmlRenderer.Renderer renderer = HtmlRenderer.createRenderer();

    public NavigatorTreeCellRenderer() {
        this.renderer.setHtml(true);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        boolean containsError;
        TreeNodeAdapter tna = (TreeNodeAdapter)value;
        DocumentElement de = tna.getDocumentElement();
        String htmlText = tna.getText(true);
        Component comp = this.renderer.getTreeCellRendererComponent(tree, (Object)htmlText, sel, expanded, leaf, row, hasFocus);
        comp.setEnabled(tree.isEnabled());
        ((JLabel)comp).setToolTipText(tna.getToolTipText().trim().length() > 0 ? tna.getToolTipText() : null);
        boolean bl = containsError = tna.getChildrenErrorCount() > 0;
        if (de.getType().equals("tag") || de.getType().equals("empty_tag")) {
            this.setIcon(this.TAG_ICON, containsError);
        } else if (de.getType().equals("pi")) {
            this.setIcon(this.PI_ICON, containsError);
        } else if (de.getType().equals("doctype")) {
            this.setIcon(this.DOCTYPE_ICON, containsError);
        } else if (de.getType().equals("cdata")) {
            this.setIcon(this.CDATA_ICON, containsError);
        }
        return comp;
    }

    public void setIcon(Icon[] icons, boolean containsError) {
        this.renderer.setIcon(icons[containsError ? 1 : 0]);
    }

    private Icon getIcon(String name, boolean error) {
        Icon icon = ImageUtilities.loadIcon((String)name);
        if (error) {
            return ImageUtilities.mergeIcons((Icon)icon, (Icon)this.ERROR_ICON, (int)15, (int)7);
        }
        return icon;
    }
}

