/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.actions;

import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.devops.DevopsClient;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import com.oracle.bmc.devops.model.DeployArtifactSummary;
import com.oracle.bmc.devops.model.InlineDeployArtifactSource;
import com.oracle.bmc.devops.model.UpdateDeployArtifactDetails;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.vault.VaultsClient;
import com.oracle.bmc.vault.model.Base64SecretContentDetails;
import com.oracle.bmc.vault.model.CreateSecretDetails;
import com.oracle.bmc.vault.model.SecretContentDetails;
import com.oracle.bmc.vault.model.SecretReuseRule;
import com.oracle.bmc.vault.model.UpdateSecretDetails;
import com.oracle.bmc.vault.requests.CreateSecretRequest;
import com.oracle.bmc.vault.requests.ListSecretsRequest;
import com.oracle.bmc.vault.requests.UpdateSecretRequest;
import com.oracle.bmc.vault.responses.ListSecretsResponse;
import com.oracle.bmc.vault.responses.UpdateSecretResponse;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cloud.oracle.OCIManager;
import org.netbeans.modules.cloud.oracle.actions.Bundle;
import org.netbeans.modules.cloud.oracle.assets.CloudAssets;
import org.netbeans.modules.cloud.oracle.assets.DependencyUtils;
import org.netbeans.modules.cloud.oracle.assets.PropertiesGenerator;
import org.netbeans.modules.cloud.oracle.assets.Steps;
import org.netbeans.modules.cloud.oracle.database.DatabaseItem;
import org.netbeans.modules.cloud.oracle.devops.DevopsProjectItem;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.netbeans.modules.cloud.oracle.steps.CompartmentStep;
import org.netbeans.modules.cloud.oracle.steps.DevopsStep;
import org.netbeans.modules.cloud.oracle.steps.KeyStep;
import org.netbeans.modules.cloud.oracle.steps.PasswordStep;
import org.netbeans.modules.cloud.oracle.steps.ProjectStep;
import org.netbeans.modules.cloud.oracle.steps.TenancyStep;
import org.netbeans.modules.cloud.oracle.vault.KeyItem;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class DevOpsProjectConfigMapUploader {
    private static final Logger LOG = Logger.getLogger(DevOpsProjectConfigMapUploader.class.getName());

    public static void uploadConfigMap(CompletableFuture<Object> future) {
        Steps.NextStepProvider.Builder nsProviderBuilder = Steps.NextStepProvider.builder();
        nsProviderBuilder.stepForClass(TenancyStep.class, s -> new CompartmentStep()).stepForClass(CompartmentStep.class, s -> new DevopsStep()).stepForClass(DevopsStep.class, s -> new ProjectStep());
        Collection<OCIItem> items = CloudAssets.getDefault().getAssignedItems();
        AtomicReference<VaultItem> vaultRef = new AtomicReference<VaultItem>();
        AtomicReference<DatabaseItem> dbRef = new AtomicReference<DatabaseItem>();
        for (OCIItem item : items) {
            String password;
            String user;
            if (item instanceof VaultItem) {
                vaultRef.set((VaultItem)item);
                nsProviderBuilder.stepForClass(PasswordStep.class, s -> new KeyStep((VaultItem)vaultRef.get()));
                continue;
            }
            if (!(item instanceof DatabaseItem)) continue;
            dbRef.set((DatabaseItem)item);
            DatabaseConnection conn = ((DatabaseItem)item).getCorrespondingConnection();
            if (conn != null) {
                user = conn.getUser();
                password = conn.getPassword();
            } else {
                user = null;
                password = null;
            }
            nsProviderBuilder.stepForClass(ProjectStep.class, s -> new PasswordStep(user, password));
        }
        if (vaultRef.get() == null && dbRef.get() != null) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.SuggestVault(), 1);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
        }
        Lookup lookup = Lookups.fixed((Object[])new Object[]{nsProviderBuilder.build()});
        Steps.getDefault().executeMultistep(new TenancyStep(), lookup).thenAccept(values -> {
            Project project = (Project)values.getValueForStep(ProjectStep.class);
            KeyItem key = (KeyItem)values.getValueForStep(KeyStep.class);
            DevopsProjectItem devopsProject = (DevopsProjectItem)values.getValueForStep(DevopsStep.class);
            ProgressHandle h = ProgressHandle.createHandle((String)Bundle.UpdatingConfigMap());
            try {
                PropertiesGenerator propGen = new PropertiesGenerator(false);
                if (vaultRef.get() != null) {
                    DevOpsProjectConfigMapUploader.updateVault(h, key, (VaultItem)vaultRef.get(), propGen, project);
                }
                if (DevOpsProjectConfigMapUploader.updateConfigMap(h, devopsProject, propGen)) {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.CMUpdated(devopsProject.getName()), 1);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                } else {
                    NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)Bundle.NoConfigMap(devopsProject.getName()), 2);
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)msg);
                }
                future.complete(null);
            }
            catch (ThreadDeath e) {
                future.completeExceptionally(e);
                throw e;
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
                NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)e.getMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            }
            finally {
                h.finish();
            }
        });
    }

    private static boolean updateConfigMap(ProgressHandle h, DevopsProjectItem devopsProject, PropertiesGenerator propGen) {
        DevopsClient devopsClient = DevopsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile(devopsProject).getConfigProvider());
        ListDeployArtifactsRequest request = ListDeployArtifactsRequest.builder().projectId(devopsProject.getKey().getValue()).build();
        ListDeployArtifactsResponse response = devopsClient.listDeployArtifacts(request);
        List artifacts = response.getDeployArtifactCollection().getItems();
        boolean found = false;
        for (DeployArtifactSummary artifact : artifacts) {
            if (!(devopsProject.getName() + "_oke_configmap").equals(artifact.getDisplayName())) continue;
            h.progress("updating  " + devopsProject.getName() + "_oke_configmap");
            found = true;
            GetDeployArtifactRequest artRequest = GetDeployArtifactRequest.builder().deployArtifactId(artifact.getId()).build();
            GetDeployArtifactResponse artResponse = devopsClient.getDeployArtifact(artRequest);
            DeployArtifactSource source = artResponse.getDeployArtifact().getDeployArtifactSource();
            if (!(source instanceof InlineDeployArtifactSource)) continue;
            byte[] content = ((InlineDeployArtifactSource)source).getBase64EncodedContent();
            String srcString = DevOpsProjectConfigMapUploader.updateProperties(new String(content, StandardCharsets.UTF_8), propGen);
            byte[] base64Content = Base64.getEncoder().encode(srcString.getBytes(StandardCharsets.UTF_8));
            InlineDeployArtifactSource updatedSource = InlineDeployArtifactSource.builder().base64EncodedContent(base64Content).build();
            UpdateDeployArtifactDetails updateArtifactDetails = UpdateDeployArtifactDetails.builder().deployArtifactSource((DeployArtifactSource)updatedSource).build();
            UpdateDeployArtifactRequest updateArtifactRequest = UpdateDeployArtifactRequest.builder().updateDeployArtifactDetails(updateArtifactDetails).deployArtifactId(artifact.getId()).build();
            devopsClient.updateDeployArtifact(updateArtifactRequest);
        }
        return found;
    }

    private static void updateVault(ProgressHandle h, KeyItem key, VaultItem vault, PropertiesGenerator propGen, Project project) {
        h.progress(Bundle.UpdatingVault(vault.getName()));
        VaultsClient client = VaultsClient.builder().build((AbstractAuthenticationDetailsProvider)OCIManager.getDefault().getActiveProfile(vault).getConfigProvider());
        ListSecretsRequest listSecretsRequest = ListSecretsRequest.builder().compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).limit(Integer.valueOf(88)).build();
        ListSecretsResponse secrets = client.listSecrets(listSecretsRequest);
        Map<String, String> existingSecrets = secrets.getItems().stream().collect(Collectors.toMap(s -> s.getSecretName(), s -> s.getId()));
        for (Map.Entry<String, String> entry : propGen.getVaultSecrets().entrySet()) {
            UpdateSecretRequest request;
            String secretName = entry.getKey();
            String base64Content = Base64.getEncoder().encodeToString(entry.getValue().getBytes(StandardCharsets.UTF_8));
            Base64SecretContentDetails contentDetails = Base64SecretContentDetails.builder().content(base64Content).stage(SecretContentDetails.Stage.Current).build();
            if (existingSecrets.containsKey(secretName)) {
                h.progress(Bundle.UpdatingSecret(secretName));
                UpdateSecretDetails updateSecretDetails = UpdateSecretDetails.builder().secretContent((SecretContentDetails)contentDetails).build();
                request = UpdateSecretRequest.builder().secretId(existingSecrets.get(secretName)).updateSecretDetails(updateSecretDetails).build();
                try {
                    UpdateSecretResponse updateSecretResponse = client.updateSecret(request);
                }
                catch (BmcException ex) {
                    LOG.log(Level.WARNING, "Update of secret failed", ex);
                }
                continue;
            }
            h.progress(Bundle.CreatingSecret(secretName));
            CreateSecretDetails createDetails = CreateSecretDetails.builder().secretName(secretName).secretContent((SecretContentDetails)contentDetails).secretRules(new ArrayList<SecretReuseRule>(Arrays.asList(SecretReuseRule.builder().isEnforcedOnDeletedSecretVersions(Boolean.valueOf(false)).build()))).compartmentId(vault.getCompartmentId()).vaultId(vault.getKey().getValue()).keyId(key.getKey().getValue()).build();
            request = CreateSecretRequest.builder().createSecretDetails(createDetails).build();
            client.createSecret((CreateSecretRequest)request);
        }
        try {
            DependencyUtils.addDependency(project, new String[]{"io.micronaut.oraclecloud", "micronaut-oraclecloud-vault"});
        }
        catch (IllegalStateException e) {
            LOG.log(Level.INFO, "Unable to add Vault dependency", e);
        }
    }

    protected static String updateProperties(String configmap, PropertiesGenerator propGen) {
        StringWriter output = new StringWriter();
        String[] lines = configmap.split("\n");
        int previousIndent = 0;
        LinkedHashMap<Integer, String> path = new LinkedHashMap<Integer, String>();
        String propertiesName = null;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line.trim().startsWith("#") || line.isEmpty()) {
                output.append(line);
                output.append("\n");
                continue;
            }
            int indent = 0;
            while (line.charAt(indent) == ' ') {
                ++indent;
            }
            if (previousIndent > indent || propertiesName != null && !line.contains("=")) {
                int f = indent;
                path.entrySet().removeIf(entry -> (Integer)entry.getKey() >= f);
                if (propertiesName != null) {
                    int propIndent = previousIndent;
                    if (properties.isEmpty()) {
                        propIndent = indent + 2;
                    }
                    output.append(DevOpsProjectConfigMapUploader.formatProperties(propertiesName, properties, propIndent, propGen));
                    properties.clear();
                }
                propertiesName = null;
                if (line.trim().equals("---")) {
                    output.append(line);
                    output.append("\n");
                    continue;
                }
            }
            if (propertiesName == null) {
                if (line.indexOf(58) < 0) {
                    throw new IllegalStateException("Invalid ConfigMap format");
                }
                String k = line.substring(0, line.indexOf(58)).trim();
                String v = line.substring(line.indexOf(58) + 1).trim();
                if (k == null) {
                    throw new IllegalStateException();
                }
                path.put(indent, k);
                output.append(line);
                output.append("\n");
                if (v.trim().equals("|")) {
                    propertiesName = k;
                    continue;
                }
            }
            if (propertiesName != null && line.contains("=")) {
                properties.put(line.substring(0, line.indexOf(61)).trim(), line.substring(line.indexOf(61) + 1).trim());
            }
            previousIndent = indent;
        }
        output.append(DevOpsProjectConfigMapUploader.formatProperties(propertiesName, properties, previousIndent, propGen));
        return output.toString();
    }

    private static String formatProperties(String proprtiesName, Map<String, String> prop, int indent, PropertiesGenerator propGen) {
        StringBuilder output = new StringBuilder();
        prop.entrySet().removeIf(entry -> propGen.getAllPropertiesNames().contains(entry.getKey()));
        if (proprtiesName.startsWith("bootstrap")) {
            prop.putAll(propGen.getBootstrap());
        } else if (proprtiesName.startsWith("application")) {
            prop.putAll(propGen.getApplication());
        }
        for (Map.Entry<String, String> entry2 : prop.entrySet()) {
            output.append(new String(new char[indent]).replace('\u0000', ' '));
            output.append(entry2.getKey());
            output.append("=");
            output.append(entry2.getValue());
            output.append("\n");
        }
        return output.toString();
    }
}

