/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.dependencies;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private List<ChangeListener> listeners;
    private boolean strike;
    private boolean italic;

    public CheckNode(Object userObject, String nodeLabel, Icon icon) {
        super(userObject, false);
        this.setSelectionMode(4);
        this.nodeLabel = nodeLabel;
        this.icon = icon;
        this.listeners = new ArrayList<ChangeListener>();
    }

    String getLabel() {
        if (this.strike) {
            return "<s>" + this.nodeLabel + "</s>";
        }
        if (this.italic) {
            return "<i>" + this.nodeLabel + "</i>";
        }
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    public final void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckNode node = (CheckNode)e.nextElement();
                node.setSelected(isSelected);
            }
        }
        this.fireChange();
    }

    public void addChangeListener(ChangeListener list) {
        this.listeners.add(list);
    }

    public void removeChangeListener(ChangeListener list) {
        this.listeners.remove(list);
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    void strike() {
        this.strike = true;
    }

    void unitalic() {
        this.italic = false;
    }

    void italic() {
        this.italic = true;
    }

    void unstrike() {
        this.strike = false;
    }

    private void fireChange() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(event);
        }
    }
}

