/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution;

import com.jcraft.jsch.JSchException;
import java.util.List;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.JschSupport;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.NbNativeProcess;
import org.openide.util.Exceptions;

public final class NbRemoteNativeProcess
extends NbNativeProcess {
    private JschSupport.ChannelStreams streams = null;

    public NbRemoteNativeProcess(NativeProcessInfo info) {
        super(info);
    }

    @Override
    protected void createProcessImpl(List<String> command) throws Throwable {
        JschSupport.ChannelParams params = new JschSupport.ChannelParams();
        params.setX11Forwarding(this.info.getX11Forwarding());
        StringBuilder sb = new StringBuilder();
        for (String arg : command) {
            sb.append('\'').append(arg).append('\'').append(' ');
        }
        this.streams = JschSupport.startCommand(this.info.getExecutionEnvironment(), sb.toString(), params);
        this.setErrorStream(this.streams.err);
        this.setInputStream(this.streams.out);
        this.setOutputStream(this.streams.in);
    }

    @Override
    public boolean isAlive() {
        if (this.streams == null || this.streams.channel == null) {
            return false;
        }
        return this.streams.channel.isConnected();
    }

    @Override
    protected int waitResultImpl() throws InterruptedException {
        if (this.streams == null || this.streams.channel == null) {
            return -1;
        }
        try {
            while (this.streams.channel.isConnected()) {
                Thread.sleep(200L);
            }
            this.finishing();
            int n = this.streams.channel.getExitStatus();
            return n;
        }
        finally {
            if (this.streams != null) {
                try {
                    ConnectionManagerAccessor.getDefault().closeAndReleaseChannel(this.getExecutionEnvironment(), this.streams.channel);
                }
                catch (JSchException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }
}

