/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class ContainerCPModifierImpl
implements ContainerClassPathModifier {
    private static final Logger LOGGER = Logger.getLogger(ContainerCPModifierImpl.class.getName());
    private final Project project;

    public ContainerCPModifierImpl(Project prj) {
        this.project = prj;
    }

    public void extendClasspath(final FileObject file, final String[] symbolicNames) {
        if (symbolicNames == null) {
            return;
        }
        final Boolean[] added = new Boolean[]{Boolean.FALSE};
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Map items = ContainerCPModifierImpl.this.createItemList();
                ProjectSourcesClassPathProvider prv = (ProjectSourcesClassPathProvider)ContainerCPModifierImpl.this.project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
                ClassPath[] cps = prv.getProjectClassPaths("classpath/compile");
                ClassPath cp = ClassPathSupport.createProxyClassPath((ClassPath[])cps);
                Profile version = Profile.JAVA_EE_5;
                WebModule wm = WebModule.getWebModule((FileObject)file);
                if (wm != null) {
                    version = wm.getJ2eeProfile();
                } else {
                    EjbJar ejb = EjbJar.getEjbJar((FileObject)file);
                    if (ejb != null) {
                        version = ejb.getJ2eeProfile();
                    }
                }
                for (String name : symbolicNames) {
                    Item item = (Item)items.get(name + ":" + version.toPropertiesString());
                    if (item != null) {
                        FileObject fo;
                        if (item.classToCheck != null && (fo = cp.findResource(item.classToCheck)) != null) continue;
                        Dependency dep = ModelUtils.checkModelDependency((POMModel)model, (String)item.groupId, (String)item.artifactId, (boolean)true);
                        dep.setVersion(item.version);
                        dep.setScope("provided");
                        added[0] = Boolean.TRUE;
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "Cannot process api with symbolic name: {0}. Nothing will be added to project''s classpath.", name);
                }
            }
        };
        FileObject pom = this.project.getProjectDirectory().getFileObject("pom.xml");
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
        if (added[0].booleanValue() && !SwingUtilities.isEventDispatchThread()) {
            ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).downloadDependencyAndJavadocSource(true);
        }
    }

    private Map<String, Item> createItemList() {
        HashMap<String, Item> toRet = new HashMap<String, Item>();
        String key = "servlet-api:" + Profile.J2EE_14.toPropertiesString();
        Item item = new Item();
        item.groupId = "javax.servlet";
        item.artifactId = "servlet-api";
        item.version = "2.4";
        item.classToCheck = "javax/servlet/http/HttpServlet.class";
        toRet.put(key, item);
        key = "servlet-api:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.servlet";
        item.artifactId = "servlet-api";
        item.version = "2.5";
        item.classToCheck = "javax/servlet/http/HttpServlet.class";
        toRet.put(key, item);
        key = "jsp-api:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "javax.servlet.jsp";
        item.artifactId = "jsp-api";
        item.version = "2.1";
        item.classToCheck = "javax/servlet/jsp/tagext/BodyContent.class";
        toRet.put(key, item);
        key = "jsp-api:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.servlet.jsp";
        item.artifactId = "jsp-api";
        item.version = "2.1";
        item.classToCheck = "javax/servlet/jsp/tagext/BodyContent.class";
        toRet.put(key, item);
        key = "jsf-api:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "javax.faces";
        item.artifactId = "jsf-api";
        item.version = "1.2";
        item.classToCheck = "javax.faces.application.StateManagerWrapper";
        toRet.put(key, item);
        key = "jsf-api:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.faces";
        item.artifactId = "jsf-api";
        item.version = "2.0";
        item.classToCheck = "javax.faces.application.ProjectStage";
        toRet.put(key, item);
        key = "j2ee-api:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "org.apache.geronimo.specs";
        item.artifactId = "geronimo-j2ee_1.4_spec";
        item.version = "1.0";
        toRet.put(key, item);
        key = "j2ee-api:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javaee";
        item.artifactId = "javaee-api";
        item.version = "5";
        toRet.put(key, item);
        key = "transaction:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "javax.transaction";
        item.artifactId = "jta";
        item.version = "1.0.1B";
        item.classToCheck = "javax/transaction/UserTransaction.class";
        toRet.put(key, item);
        key = "transaction:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.transaction";
        item.artifactId = "jta";
        item.version = "1.1";
        item.classToCheck = "javax/transaction/UserTransaction.class";
        toRet.put(key, item);
        key = "persistence:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "javax.persistence";
        item.artifactId = "persistence-api";
        item.version = "1.0";
        item.classToCheck = "javax/persistence/PersistenceContext.class";
        toRet.put(key, item);
        key = "persistence:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.persistence";
        item.artifactId = "persistence-api";
        item.version = "1.0";
        item.classToCheck = "javax/persistence/PersistenceContext.class";
        toRet.put(key, item);
        key = "annotation:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "javax.annotation";
        item.artifactId = "jsr250-api";
        item.version = "1.0";
        item.classToCheck = "javax/annotation/Resource.class";
        toRet.put(key, item);
        key = "annotation:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "javax.annotation";
        item.artifactId = "jsr250-api";
        item.version = "1.0";
        item.classToCheck = "javax/annotation/Resource.class";
        toRet.put(key, item);
        key = "ejb:" + Profile.J2EE_14.toPropertiesString();
        item = new Item();
        item.groupId = "org.apache.geronimo.specs";
        item.artifactId = "geronimo-ejb_2.1_spec";
        item.version = "1.1";
        item.classToCheck = "javax/ejb/EJB.class";
        toRet.put(key, item);
        key = "ejb:" + Profile.JAVA_EE_5.toPropertiesString();
        item = new Item();
        item.groupId = "org.apache.geronimo.specs";
        item.artifactId = "geronimo-ejb_3.0_spec";
        item.version = "1.0.1";
        item.classToCheck = "javax/ejb/EJB.class";
        toRet.put(key, item);
        return toRet;
    }

    private static class Item {
        String classToCheck;
        String groupId;
        String artifactId;
        String version;

        private Item() {
        }
    }
}

