/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.nette2;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.php.api.framework.BadgeIcon;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.phpmodule.PhpModuleProperties;
import org.netbeans.modules.php.nette2.Bundle;
import org.netbeans.modules.php.nette2.ConfigurationFiles;
import org.netbeans.modules.php.nette2.Nette2PhpModuleExtender;
import org.netbeans.modules.php.nette2.annotations.Nette2AnnotationsProvider;
import org.netbeans.modules.php.nette2.preferences.Nette2Preferences;
import org.netbeans.modules.php.nette2.ui.actions.Nette2PhpModuleActionsExtender;
import org.netbeans.modules.php.nette2.ui.customizer.Nette2CustomizerExtender;
import org.netbeans.modules.php.spi.annotation.AnnotationCompletionTagProvider;
import org.netbeans.modules.php.spi.framework.PhpFrameworkProvider;
import org.netbeans.modules.php.spi.framework.PhpModuleActionsExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleCustomizerExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleExtender;
import org.netbeans.modules.php.spi.framework.PhpModuleIgnoredFilesExtender;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommandSupport;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class Nette2FrameworkProvider
extends PhpFrameworkProvider {
    private static final Nette2FrameworkProvider INSTANCE = new Nette2FrameworkProvider();
    private final BadgeIcon badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/php/nette2/ui/resources/nette_badge_8.png"), Nette2FrameworkProvider.class.getResource("/org/netbeans/modules/php/nette2/ui/resources/nette_badge_8.png"));

    public static Nette2FrameworkProvider getInstance() {
        return INSTANCE;
    }

    private Nette2FrameworkProvider() {
        super("Nette2 PHP Web Framework", Bundle.LBL_FrameworkName(), Bundle.LBL_FrameworkDescription());
    }

    public boolean isInPhpModule(PhpModule phpModule) {
        FileObject sourceDirectory;
        boolean result = Nette2Preferences.isManuallyEnabled(phpModule);
        if (!result && (sourceDirectory = phpModule.getSourceDirectory()) != null) {
            FileObject bootstrap = this.getFileObject(sourceDirectory, "app/bootstrap.php");
            result = bootstrap != null && !bootstrap.isFolder() && bootstrap.isValid();
            FileObject config = this.getFileObject(sourceDirectory, "app/config");
            result = result && config != null && config.isFolder() && config.isValid();
        }
        return result;
    }

    public ImportantFilesImplementation getConfigurationFiles2(PhpModule phpModule) {
        return new ConfigurationFiles(phpModule);
    }

    public PhpModuleExtender createPhpModuleExtender(PhpModule phpModule) {
        return new Nette2PhpModuleExtender();
    }

    public PhpModuleProperties getPhpModuleProperties(PhpModule phpModule) {
        return new PhpModuleProperties();
    }

    public PhpModuleActionsExtender getActionsExtender(PhpModule phpModule) {
        return new Nette2PhpModuleActionsExtender();
    }

    public PhpModuleIgnoredFilesExtender getIgnoredFilesExtender(PhpModule phpModule) {
        return new PhpModuleIgnoredFilesExtender(){

            public Set<File> getIgnoredFiles() {
                return Collections.emptySet();
            }
        };
    }

    public FrameworkCommandSupport getFrameworkCommandSupport(PhpModule phpModule) {
        return null;
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public List<AnnotationCompletionTagProvider> getAnnotationsCompletionTagProviders(PhpModule phpModule) {
        return Collections.singletonList(new Nette2AnnotationsProvider());
    }

    public PhpModuleCustomizerExtender createPhpModuleCustomizerExtender(PhpModule phpModule) {
        return new Nette2CustomizerExtender(phpModule);
    }

    private FileObject getFileObject(FileObject parent, String relPath) {
        File parentFile = FileUtil.toFile((FileObject)parent);
        if (parentFile != null) {
            String nativePath = relPath.replace('/', File.separatorChar);
            File file = new File(parentFile, nativePath);
            return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        }
        return null;
    }
}

