/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.vars;

import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.vars.V8Value;

public class V8Object
extends V8Value {
    private final String className;
    private final PropertyLong constructorFunctionHandle;
    private final PropertyLong protoObjectHandle;
    private final PropertyLong prototypeObjectHandle;
    private final Map<String, Property> properties;
    private final Array array;

    public V8Object(long handle, V8Value.Type type, String className, PropertyLong constructorFunctionHandle, PropertyLong protoObjectHandle, PropertyLong prototypeObjectHandle, Map<String, Property> properties, Array array, String text) {
        super(handle, type, text);
        this.className = className;
        this.constructorFunctionHandle = constructorFunctionHandle;
        this.protoObjectHandle = protoObjectHandle;
        this.prototypeObjectHandle = prototypeObjectHandle;
        this.properties = properties;
        this.array = array;
    }

    protected V8Object(long handle, V8Value.Type type, String className, PropertyLong constructorFunctionHandle, PropertyLong protoObjectHandle, PropertyLong prototypeObjectHandle, Map<String, Property> properties, String text) {
        this(handle, type, className, constructorFunctionHandle, protoObjectHandle, prototypeObjectHandle, properties, null, text);
    }

    public String getClassName() {
        return this.className;
    }

    public PropertyLong getConstructorFunctionHandle() {
        return this.constructorFunctionHandle;
    }

    public PropertyLong getProtoObjectHandle() {
        return this.protoObjectHandle;
    }

    public PropertyLong getPrototypeObjectHandle() {
        return this.prototypeObjectHandle;
    }

    public Map<String, Property> getProperties() {
        return this.properties;
    }

    public Array getArray() {
        return this.array;
    }

    public static interface Array {
        public long getReferenceAt(long var1) throws NoSuchElementException;

        public IndexIterator getIndexIterator();

        public boolean isContiguous();

        public long[] getContiguousReferences() throws UnsupportedOperationException;

        public long getLength();
    }

    public static final class DefaultArray
    implements Array {
        private long[] references;
        private long[] indexes;
        private int length;

        public DefaultArray(long[] references) {
            this.references = references;
            this.indexes = null;
            this.length = references.length;
        }

        public DefaultArray() {
            this.references = new long[0];
            this.indexes = null;
            this.length = 0;
        }

        public void putReferenceAt(long index, long reference) {
            if (this.indexes == null) {
                if (index < (long)this.length) {
                    this.references[(int)index] = reference;
                } else if (index == (long)this.length) {
                    if ((long)this.references.length <= index) {
                        int newLength = this.getNewLength();
                        this.references = Arrays.copyOf(this.references, newLength);
                    }
                    this.references[this.length++] = reference;
                } else {
                    int newLength = this.references.length;
                    if (newLength <= this.length) {
                        newLength = this.getNewLength();
                        this.references = Arrays.copyOf(this.references, newLength);
                    }
                    this.indexes = new long[newLength];
                    for (int i = 0; i < this.length; ++i) {
                        this.indexes[i] = i;
                    }
                    this.indexes[this.length] = index;
                    this.references[this.length] = reference;
                    ++this.length;
                }
            } else {
                if (this.references.length <= this.length) {
                    int newLength = this.getNewLength();
                    this.references = Arrays.copyOf(this.references, newLength);
                    this.indexes = Arrays.copyOf(this.indexes, newLength);
                }
                this.indexes[this.length] = index;
                this.references[this.length] = reference;
                ++this.length;
            }
        }

        private int getNewLength() {
            int newLength = this.length + (this.length >> 1);
            if (newLength < 10) {
                newLength = 10;
            }
            if (newLength <= this.length && (newLength = 0x7FFFFFF7) <= this.length) {
                if (this.length == Integer.MAX_VALUE) {
                    throw new OutOfMemoryError("Unable to allocate an array longer than 2147483647 bytes.");
                }
                newLength = Integer.MAX_VALUE;
            }
            return newLength;
        }

        @Override
        public long getReferenceAt(long index) throws NoSuchElementException {
            if (this.indexes == null) {
                if (index >= (long)this.length) {
                    throw new NoSuchElementException("No reference at " + index + ", array length is " + this.length);
                }
                return this.references[(int)index];
            }
            int pos = this.getPositionOf(index);
            if (pos < 0) {
                throw new NoSuchElementException("No reference at " + index);
            }
            return this.references[pos];
        }

        private int getPositionOf(long index) {
            int p1 = 0;
            int p2 = this.length - 1;
            while (p1 <= p2) {
                int p = p1 + (p2 - p1) / 2;
                long pi = this.indexes[p];
                if (pi == index) {
                    return p;
                }
                if (p1 == p2) {
                    return -1;
                }
                if (pi < index) {
                    if (p1 == p) {
                        ++p1;
                        continue;
                    }
                    p1 = p;
                    continue;
                }
                p2 = p;
            }
            return -1;
        }

        @Override
        public IndexIterator getIndexIterator() {
            return new DefaultIndexIterator();
        }

        @Override
        public boolean isContiguous() {
            return this.indexes == null;
        }

        @Override
        public long[] getContiguousReferences() throws UnsupportedOperationException {
            if (this.indexes == null) {
                if (this.references.length > this.length) {
                    this.references = Arrays.copyOf(this.references, this.length);
                }
                return this.references;
            }
            throw new UnsupportedOperationException("The array is not contiguous.");
        }

        @Override
        public long getLength() {
            if (this.indexes == null) {
                return this.length;
            }
            if (this.length == 0) {
                return 0L;
            }
            long maxIndex = this.indexes[this.length - 1];
            return maxIndex + 1L;
        }

        private final class DefaultIndexIterator
        implements IndexIterator {
            private int pos = 0;

            private DefaultIndexIterator() {
            }

            @Override
            public boolean hasNextIndex() {
                return this.pos < DefaultArray.this.length;
            }

            @Override
            public long nextIndex() throws NoSuchElementException {
                if (this.pos >= DefaultArray.this.length) {
                    throw new NoSuchElementException("Length = " + DefaultArray.this.length);
                }
                if (DefaultArray.this.indexes == null) {
                    return this.pos++;
                }
                return DefaultArray.this.indexes[this.pos++];
            }
        }
    }

    public static interface IndexIterator {
        public boolean hasNextIndex();

        public long nextIndex() throws NoSuchElementException;
    }

    public static final class Property {
        public static final int ATTR_NONE = 0;
        public static final int ATTR_READ_ONLY = 1;
        public static final int ATTR_DONT_ENUM = 2;
        public static final int ATTR_DONT_DELETE = 4;
        public static final int ATTR_SEALED = 4;
        public static final int ATTR_FROZEN = 5;
        public static final int ATTR_STRING = 8;
        public static final int ATTR_SYMBOLIC = 16;
        public static final int ATTR_PRIVATE_SYMBOL = 32;
        public static final int ATTR_DONT_SHOW = 50;
        public static final int ATTR_ABSENT = 64;
        private final String name;
        private final Type type;
        private final int attributes;
        private final long reference;

        public Property(String name, Type type, int attributes, long reference) {
            this.name = name;
            this.type = type;
            this.attributes = attributes;
            this.reference = reference;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }

        public int getAttributes() {
            return this.attributes;
        }

        public long getReference() {
            return this.reference;
        }

        public static enum Type {
            Normal,
            Field,
            Constant,
            Callbacks,
            Handler,
            Interceptor,
            Transition,
            Nonexistent;

        }
    }
}

